/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlx;

public class zzlo
implements CastRemoteDisplayApi {
    private static final zzl zzYy = new zzl("CastRemoteDisplayApiImpl");
    private Api.zzc<zzlp> zzacX;
    private VirtualDisplay zzacY;
    private final zzls zzacZ = new zzls.zza(){

        @Override
        public void zzbp(int n) {
            zzYy.zzb("onRemoteDisplayEnded", new Object[0]);
            zzlo.this.zzoj();
        }
    };

    public zzlo(Api.zzc<zzlp> zzc2) {
        this.zzacX = zzc2;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient apiClient, final String appId) {
        zzYy.zzb("startRemoteDisplay", new Object[0]);
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            protected void zza(zzlp zzlp2) throws RemoteException {
                zzlp2.zza(new zzb.zza(zzlp2), zzlo.this.zzacZ, appId);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient apiClient) {
        zzYy.zzb("stopRemoteDisplay", new Object[0]);
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            protected void zza(zzlp zzlp2) throws RemoteException {
                zzlp2.zza(new zzb.zzb());
            }
        });
    }

    private void zzoj() {
        if (this.zzacY != null) {
            Display display = this.zzacY.getDisplay();
            if (display != null) {
                zzYy.zzb("releasing virtual display: " + this.zzacY.getDisplay().getDisplayId(), new Object[0]);
            }
            this.zzacY.release();
            this.zzacY = null;
        }
    }

    private abstract class com.google.android.gms.internal.zzlo$zzb
    extends zzlx.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzlp> {
        public com.google.android.gms.internal.zzlo$zzb(GoogleApiClient googleApiClient) {
            super(zzlo.this.zzacX, googleApiClient);
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzt(Status status) {
            return new zzc(status);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzt(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzlo$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzYy.zzb("onDisconnected", new Object[0]);
                zzlo.this.zzoj();
                zzb.this.zzb(new zzc(Status.zzaeX));
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzYy.zzb("onError: %d", statusCode);
                zzlo.this.zzoj();
                zzb.this.zzb(new zzc(Status.zzaeZ));
            }
        }

        protected final class zza
        extends com.google.android.gms.internal.zzlo$zza {
            private final zzlp zzadc;

            public zza(zzlp zzlp2) {
                this.zzadc = zzlp2;
            }

            private int zzj(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzYy.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzadc.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzYy.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaeZ));
                    return;
                }
                zzlo.this.zzoj();
                int n3 = this.zzj(n, n2);
                zzlo.this.zzacY = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzlo.this.zzacY == null) {
                    zzYy.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaeZ));
                    return;
                }
                Display display = zzlo.this.zzacY.getDisplay();
                if (display == null) {
                    zzYy.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaeZ));
                    return;
                }
                try {
                    this.zzadc.zza(this, zzlo.this.zzacY.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzYy.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaeZ));
                }
            }

            @Override
            public void zzol() {
                zzYy.zzb("onConnectedWithDisplay", new Object[0]);
                Display display = zzlo.this.zzacY.getDisplay();
                if (display != null) {
                    zzb.this.zzb(new zzc(display));
                } else {
                    zzYy.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaeZ));
                }
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzYy.zzb("onError: %d", statusCode);
                zzlo.this.zzoj();
                zzb.this.zzb(new zzc(Status.zzaeZ));
            }
        }
    }

    private abstract class zza
    extends zzlq.zza {
        private zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int statusCode) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzol() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzTA;
        private final Display zzYK;

        public zzc(Display display) {
            this.zzTA = Status.zzaeX;
            this.zzYK = display;
        }

        public zzc(Status status) {
            this.zzTA = status;
            this.zzYK = null;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzYK;
        }
    }
}

