/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int mVersionCode;
    String zzZC;
    String mName;
    List<WebImage> zzxX;
    List<String> zzZD;
    String zzZE;
    Uri zzZF;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.mVersionCode = versionCode;
        this.zzZC = applicationId;
        this.mName = name;
        this.zzxX = images;
        this.zzZD = namespaces;
        this.zzZE = senderAppIdentifier;
        this.zzZF = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzxX = new ArrayList<WebImage>();
        this.zzZD = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzZC;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzZD != null && this.zzZD.contains(namespace);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzZD);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzZD != null && this.zzZD.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzZE;
    }

    public Uri zznx() {
        return this.zzZF;
    }

    public List<WebImage> getImages() {
        return this.zzxX;
    }

    public String toString() {
        return "applicationId: " + this.zzZC + ", name: " + this.mName + ", images.count: " + (this.zzxX == null ? 0 : this.zzxX.size()) + ", namespaces.count: " + (this.zzZD == null ? 0 : this.zzZD.size()) + ", senderAppIdentifier: " + this.zzZE + ", senderAppLaunchUrl: " + this.zzZF;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mVersionCode, this.zzZC, this.mName, this.zzxX, this.zzZD, this.zzZE, this.zzZF});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzf.zza(this.zzZC, applicationMetadata.zzZC) && zzf.zza(this.zzxX, applicationMetadata.zzxX) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzZD, applicationMetadata.zzZD) && zzf.zza(this.zzZE, applicationMetadata.zzZE) && zzf.zza(this.zzZF, applicationMetadata.zzZF);
    }
}

