/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzlp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zzaaW = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzaaX = new zza().zzc("com.google.android.gms.cast.metadata.CREATION_DATE", "creationDateTime", 4).zzc("com.google.android.gms.cast.metadata.RELEASE_DATE", "releaseDate", 4).zzc("com.google.android.gms.cast.metadata.BROADCAST_DATE", "originalAirdate", 4).zzc("com.google.android.gms.cast.metadata.TITLE", "title", 1).zzc("com.google.android.gms.cast.metadata.SUBTITLE", "subtitle", 1).zzc("com.google.android.gms.cast.metadata.ARTIST", "artist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_ARTIST", "albumArtist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_TITLE", "albumName", 1).zzc("com.google.android.gms.cast.metadata.COMPOSER", "composer", 1).zzc("com.google.android.gms.cast.metadata.DISC_NUMBER", "discNumber", 2).zzc("com.google.android.gms.cast.metadata.TRACK_NUMBER", "trackNumber", 2).zzc("com.google.android.gms.cast.metadata.SEASON_NUMBER", "season", 2).zzc("com.google.android.gms.cast.metadata.EPISODE_NUMBER", "episode", 2).zzc("com.google.android.gms.cast.metadata.SERIES_TITLE", "seriesTitle", 1).zzc("com.google.android.gms.cast.metadata.STUDIO", "studio", 1).zzc("com.google.android.gms.cast.metadata.WIDTH", "width", 2).zzc("com.google.android.gms.cast.metadata.HEIGHT", "height", 2).zzc("com.google.android.gms.cast.metadata.LOCATION_NAME", "location", 1).zzc("com.google.android.gms.cast.metadata.LOCATION_LATITUDE", "latitude", 3).zzc("com.google.android.gms.cast.metadata.LOCATION_LONGITUDE", "longitude", 3);
    private final List<WebImage> zzxX = new ArrayList<WebImage>();
    private final Bundle zzaaY = new Bundle();
    private int zzaaZ;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int mediaType) {
        this.zzaaZ = mediaType;
    }

    public int getMediaType() {
        return this.zzaaZ;
    }

    public void clear() {
        this.zzaaY.clear();
        this.zzxX.clear();
    }

    public boolean containsKey(String key) {
        return this.zzaaY.containsKey(key);
    }

    public Set<String> keySet() {
        return this.zzaaY.keySet();
    }

    public void putString(String key, String value) {
        this.zzf(key, 1);
        this.zzaaY.putString(key, value);
    }

    public String getString(String key) {
        this.zzf(key, 1);
        return this.zzaaY.getString(key);
    }

    public void putInt(String key, int value) {
        this.zzf(key, 2);
        this.zzaaY.putInt(key, value);
    }

    public int getInt(String key) {
        this.zzf(key, 2);
        return this.zzaaY.getInt(key);
    }

    public void putDouble(String key, double value) {
        this.zzf(key, 3);
        this.zzaaY.putDouble(key, value);
    }

    public double getDouble(String key) {
        this.zzf(key, 3);
        return this.zzaaY.getDouble(key);
    }

    public void putDate(String key, Calendar value) {
        this.zzf(key, 4);
        this.zzaaY.putString(key, zzlp.zza(value));
    }

    public Calendar getDate(String key) {
        this.zzf(key, 4);
        String string = this.zzaaY.getString(key);
        return string != null ? zzlp.zzco(string) : null;
    }

    public String getDateAsString(String key) {
        this.zzf(key, 4);
        return this.zzaaY.getString(key);
    }

    private void zzf(String string, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzaaX.zzcc(string);
        if (n2 != n && n2 != 0) {
            throw new IllegalArgumentException("Value for " + string + " must be a " + zzaaW[n]);
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zzaaZ);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zzlp.zza(jSONObject, this.zzxX);
        switch (this.zzaaZ) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void zzg(JSONObject jSONObject) {
        this.clear();
        this.zzaaZ = 0;
        try {
            this.zzaaZ = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zzlp.zza(this.zzxX, jSONObject);
        switch (this.zzaaZ) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zzb(jSONObject, new String[0]);
            }
        }
    }

    private void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string : stringArray) {
                if (!this.zzaaY.containsKey(string)) continue;
                int n = zzaaX.zzcc(string);
                switch (n) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzaaX.zzca(string), (Object)this.zzaaY.getString(string));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzaaX.zzca(string), this.zzaaY.getInt(string));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzaaX.zzca(string), this.zzaaY.getDouble(string));
                        continue block7;
                    }
                }
            }
            for (String string : this.zzaaY.keySet()) {
                if (string.startsWith("com.google.")) continue;
                Object object = this.zzaaY.get(string);
                if (object instanceof String) {
                    jSONObject.put(string, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string, object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if ("metadataType".equals(string)) continue;
                String string2 = zzaaX.zzcb(string);
                if (string2 != null) {
                    if (!hashSet.contains(string2)) continue;
                    try {
                        object = jSONObject.get(string);
                        if (object == null) continue;
                        switch (zzaaX.zzcc(string2)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzaaY.putString(string2, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = zzlp.zzco((String)object);
                                if (calendar == null) continue block10;
                                this.zzaaY.putString(string2, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzaaY.putInt(string2, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzaaY.putDouble(string2, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string);
                if (object instanceof String) {
                    this.zzaaY.putString(string, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzaaY.putInt(string, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzaaY.putDouble(string, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)other;
        return this.zzb(this.zzaaY, mediaMetadata.zzaaY) && this.zzxX.equals(mediaMetadata.zzxX);
    }

    public int hashCode() {
        int n = 17;
        Set set = this.zzaaY.keySet();
        for (String string : set) {
            n = 31 * n + this.zzaaY.get(string).hashCode();
        }
        n = 31 * n + this.zzxX.hashCode();
        return n;
    }

    public List<WebImage> getImages() {
        return this.zzxX;
    }

    public boolean hasImages() {
        return this.zzxX != null && !this.zzxX.isEmpty();
    }

    public void clearImages() {
        this.zzxX.clear();
    }

    public void addImage(WebImage image) {
        this.zzxX.add(image);
    }

    private boolean zzb(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string : set) {
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zzb((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static class zza {
        private final Map<String, String> zzaba = new HashMap<String, String>();
        private final Map<String, String> zzabb = new HashMap<String, String>();
        private final Map<String, Integer> zzabc = new HashMap<String, Integer>();

        public zza zzc(String string, String string2, int n) {
            this.zzaba.put(string, string2);
            this.zzabb.put(string2, string);
            this.zzabc.put(string, n);
            return this;
        }

        public String zzca(String string) {
            return this.zzaba.get(string);
        }

        public String zzcb(String string) {
            return this.zzabb.get(string);
        }

        public int zzcc(String string) {
            Integer n = this.zzabc.get(string);
            return n != null ? n : 0;
        }
    }
}

