/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznb;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzabd;
    private int zzabe = 0;
    private boolean zzabf = true;
    private double zzabg;
    private double zzabh = Double.POSITIVE_INFINITY;
    private double zzabi;
    private long[] zzabj;
    private JSONObject zzaaU;

    private MediaQueueItem(MediaInfo media) throws IllegalArgumentException {
        if (media == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzabd = media;
    }

    MediaQueueItem(JSONObject json) throws JSONException {
        this.zzh(json);
    }

    private MediaQueueItem(MediaQueueItem item) throws IllegalArgumentException {
        this.zzabd = item.getMedia();
        if (this.zzabd == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzabe = item.getItemId();
        this.zzabf = item.getAutoplay();
        this.zzabg = item.getStartTime();
        this.zzabh = item.getPlaybackDuration();
        this.zzabi = item.getPreloadTime();
        this.zzabj = item.getActiveTrackIds();
        this.zzaaU = item.getCustomData();
    }

    public boolean zzh(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzabd = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzabe != (n = jSONObject.getInt("itemId"))) {
            this.zzabe = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzabf != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzabf = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzabg) > 1.0E-7) {
            this.zzabg = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzabh) > 1.0E-7) {
            this.zzabh = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzabi) > 1.0E-7) {
            this.zzabi = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzabj == null) {
                bl2 = true;
            } else if (this.zzabj.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzabj[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzabj = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzaaU = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzabd;
    }

    public int getItemId() {
        return this.zzabe;
    }

    void zzba(int n) {
        this.zzabe = n;
    }

    public boolean getAutoplay() {
        return this.zzabf;
    }

    void zzV(boolean bl) {
        this.zzabf = bl;
    }

    public double getStartTime() {
        return this.zzabg;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzabg = d;
    }

    public double getPlaybackDuration() {
        return this.zzabh;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzabh = d;
    }

    public double getPreloadTime() {
        return this.zzabi;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzabi = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzabj;
    }

    void zza(long[] lArray) {
        this.zzabj = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzaaU;
    }

    void setCustomData(JSONObject customData) {
        this.zzaaU = customData;
    }

    void zznN() throws IllegalArgumentException {
        if (this.zzabd == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzabg) || this.zzabg < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzabh)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzabi) || this.zzabi < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzabd.toJson());
            if (this.zzabe != 0) {
                jSONObject.put("itemId", this.zzabe);
            }
            jSONObject.put("autoplay", this.zzabf);
            jSONObject.put("startTime", this.zzabg);
            if (this.zzabh != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzabh);
            }
            jSONObject.put("preloadTime", this.zzabi);
            if (this.zzabj != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzabj) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzaaU != null) {
                jSONObject.put("customData", (Object)this.zzaaU);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)other;
        if (this.zzaaU == null != (mediaQueueItem.zzaaU == null)) {
            return false;
        }
        if (this.zzaaU != null && mediaQueueItem.zzaaU != null && !zznb.zze((Object)this.zzaaU, (Object)mediaQueueItem.zzaaU)) {
            return false;
        }
        return zzf.zza(this.zzabd, mediaQueueItem.zzabd) && this.zzabe == mediaQueueItem.zzabe && this.zzabf == mediaQueueItem.zzabf && this.zzabg == mediaQueueItem.zzabg && this.zzabh == mediaQueueItem.zzabh && this.zzabi == mediaQueueItem.zzabi && zzf.zza(this.zzabj, mediaQueueItem.zzabj);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzabd, this.zzabe, this.zzabf, this.zzabg, this.zzabh, this.zzabi, this.zzabj, String.valueOf(this.zzaaU)});
    }

    public static class Builder {
        private final MediaQueueItem zzabk;

        public Builder(MediaInfo media) throws IllegalArgumentException {
            this.zzabk = new MediaQueueItem(media);
        }

        public Builder(JSONObject json) throws JSONException {
            this.zzabk = new MediaQueueItem(json);
        }

        public Builder(MediaQueueItem item) throws IllegalArgumentException {
            this.zzabk = new MediaQueueItem(item);
        }

        public Builder clearItemId() {
            this.zzabk.zzba(0);
            return this;
        }

        public Builder setAutoplay(boolean autoplay) {
            this.zzabk.zzV(autoplay);
            return this;
        }

        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            this.zzabk.zzc(startTime);
            return this;
        }

        public Builder setPlaybackDuration(double playbackDuration) {
            this.zzabk.zzd(playbackDuration);
            return this;
        }

        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            this.zzabk.zze(preloadTime);
            return this;
        }

        public Builder setActiveTrackIds(long[] activeTrackIds) {
            this.zzabk.zza(activeTrackIds);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzabk.setCustomData(customData);
            return this;
        }

        public MediaQueueItem build() {
            this.zzabk.zznN();
            return this.zzabk;
        }
    }
}

