/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzabl = 0;
    private long zzabm;
    private MediaInfo zzaaV;
    private double zzabn;
    private int zzabo;
    private int zzabp;
    private long zzabq;
    private long zzabr;
    private double zzabs;
    private boolean zzabt;
    private long[] zzabj;
    private JSONObject zzaaU;
    private int zzabu = 0;
    private int zzabv = 0;
    private final zza zzabw = new zza();

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zznO() {
        return this.zzabm;
    }

    public int getPlayerState() {
        return this.zzabo;
    }

    public int getIdleReason() {
        return this.zzabp;
    }

    public double getPlaybackRate() {
        return this.zzabn;
    }

    public MediaInfo getMediaInfo() {
        return this.zzaaV;
    }

    public long getStreamPosition() {
        return this.zzabq;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzabr & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzabs;
    }

    public boolean isMute() {
        return this.zzabt;
    }

    public long[] getActiveTrackIds() {
        return this.zzabj;
    }

    public JSONObject getCustomData() {
        return this.zzaaU;
    }

    public int getCurrentItemId() {
        return this.zzabl;
    }

    public int getLoadingItemId() {
        return this.zzabu;
    }

    public int getPreloadedItemId() {
        return this.zzabv;
    }

    public int getQueueRepeatMode() {
        return this.zzabw.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzabw.zznP();
    }

    public int getQueueItemCount() {
        return this.zzabw.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int itemId) {
        return this.zzabw.zzbb(itemId);
    }

    public MediaQueueItem getQueueItem(int index) {
        return this.zzabw.zzbc(index);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzabm) {
            this.zzabm = l3;
            n5 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n6 = 1;
            } else if (string.equals("PLAYING")) {
                n6 = 2;
            } else if (string.equals("PAUSED")) {
                n6 = 3;
            } else if (string.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzabo) {
                this.zzabo = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string.equals("FINISHED")) {
                    n7 = 1;
                } else if (string.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzabp) {
                    this.zzabp = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzabn != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzabn = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzg(jSONObject.getDouble("currentTime"))) != this.zzabq) {
            this.zzabq = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzabr) {
            this.zzabr = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzabs) {
                this.zzabs = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzabt) {
                this.zzabt = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzabj == null) {
                bl = true;
            } else if (this.zzabj.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzabj[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzabj = lArray;
            }
        } else if (this.zzabj != null) {
            bl = true;
        }
        if (bl) {
            this.zzabj = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzaaU = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzaaV = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzabl != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzabl = n3;
            n5 |= 2;
        }
        if (this.zzabv != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzabv = n2;
            n5 |= 0x10;
        }
        if (this.zzabu != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzabu = n4;
            n5 |= 2;
        }
        if (!this.zzi(this.zzabo, this.zzabu)) {
            if (this.zzabw.zzh(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzabl = 0;
            this.zzabu = 0;
            this.zzabv = 0;
            if (this.zzabw.getItemCount() > 0) {
                this.zzabw.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzi(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzabx = 0;
        private List<MediaQueueItem> zzaby = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzabz = new SparseArray();

        zza() {
        }

        private boolean zzh(JSONObject jSONObject) throws JSONException {
            int n;
            String string;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string2;
                int n2 = this.zzabx;
                string = string2 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string.hashCode()) {
                    case 1645952171: {
                        if (!string.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzabx != n2) {
                    this.zzabx = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzbb(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzh(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzbd(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzabl) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzaaV).build();
                        mediaQueueItemArray[i].zzh(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzaby.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzabx;
        }

        public List<MediaQueueItem> zznP() {
            return Collections.unmodifiableList(this.zzaby);
        }

        public int getItemCount() {
            return this.zzaby.size();
        }

        public MediaQueueItem zzbb(int n) {
            Integer n2 = (Integer)this.zzabz.get(n);
            return n2 == null ? null : this.zzaby.get(n2);
        }

        public MediaQueueItem zzbc(int n) {
            if (n < 0 || n >= this.zzaby.size()) {
                return null;
            }
            return this.zzaby.get(n);
        }

        private Integer zzbd(int n) {
            return (Integer)this.zzabz.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzaby.clear();
            this.zzabz.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzaby.add(mediaQueueItem);
                this.zzabz.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzabx = 0;
            this.zzaby.clear();
            this.zzabz.clear();
        }
    }
}

