/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

@SuppressLint(value={"MissingRemoteException"})
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzpV = new Object();
    private final zzm zzabE;
    private final zza zzabF = new zza();
    private OnPreloadStatusUpdatedListener zzabG;
    private OnQueueStatusUpdatedListener zzabH;
    private OnMetadataUpdatedListener zzabI;
    private OnStatusUpdatedListener zzabJ;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.zzabE = new zzm(null){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            protected void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            protected void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }
        };
        this.zzabE.zza(this.zzabF);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zzb(this.zzacm, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zzc(this.zzacm, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, volume, customData);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, muteState, customData);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        if (trackIds == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, trackIds);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient apiClient, MediaQueueItem[] items, int startIndex, int repeatMode, JSONObject customData) throws IllegalArgumentException {
        return this.queueLoad(apiClient, items, startIndex, repeatMode, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient apiClient, final MediaQueueItem[] items, final int startIndex, final int repeatMode, final long playPosition, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, items, startIndex, repeatMode, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToInsert, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, itemsToInsert, insertBeforeItemId, 0, -1, -1L, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient apiClient, MediaQueueItem item, JSONObject customData) throws IllegalArgumentException {
        return this.queueInsertItems(apiClient, new MediaQueueItem[]{item}, 0, customData);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient apiClient, MediaQueueItem item, int insertBeforeItemId, JSONObject customData) {
        return this.queueInsertAndPlayItem(apiClient, item, insertBeforeItemId, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient apiClient, final MediaQueueItem item, final int insertBeforeItemId, final long playPosition, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, new MediaQueueItem[]{item}, insertBeforeItemId, 0, 0, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToUpdate, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, 0, -1L, itemsToUpdate, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient apiClient, final int[] itemIdsToRemove, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, itemIdsToRemove, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient apiClient, final int[] itemIdsToReorder, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, itemIdsToReorder, insertBeforeItemId, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, 0, -1L, null, -1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, 0, -1L, null, 1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient apiClient, final int repeatMode, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, 0, -1L, null, 0, (Integer)repeatMode, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient apiClient, final int itemId, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbf(itemId) == -1) {
                        this.zza(this.zzq(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, new int[]{itemId}, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient apiClient, int itemId, JSONObject customData) {
        return this.queueJumpToItem(apiClient, itemId, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient apiClient, final int itemId, final long playPosition, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbf(itemId) == -1) {
                        this.zza(this.zzq(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, itemId, playPosition, null, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient apiClient, final int itemId, final int newIndex, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpV;
                synchronized (object) {
                    int n = RemoteMediaPlayer.this.zzbf(itemId);
                    if (n == -1) {
                        this.zza(this.zzq(new Status(0)));
                        return;
                    }
                    if (newIndex < 0) {
                        this.zza(this.zzq(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", newIndex))));
                        return;
                    }
                    if (n == newIndex) {
                        this.zza(this.zzq(new Status(0)));
                        return;
                    }
                    int n2 = newIndex > n ? newIndex + 1 : newIndex;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n2);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzabF.zzc(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzabE.zza(this.zzacm, new int[]{itemId}, n3, customData);
                    }
                    catch (IOException iOException) {
                        this.zza(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzabF.zzc(null);
                    }
                }
            }
        });
    }

    private int zzbf(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzabE.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzabE.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzabE.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzabE.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.zzabJ = listener;
    }

    private void onStatusUpdated() {
        if (this.zzabJ != null) {
            this.zzabJ.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.zzabI = listener;
    }

    private void onMetadataUpdated() {
        if (this.zzabI != null) {
            this.zzabI.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener listener) {
        this.zzabH = listener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzabH != null) {
            this.zzabH.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener listener) {
        this.zzabG = listener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzabG != null) {
            this.zzabG.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzabE.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.zzabE.zzcf(message);
    }

    private static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzo zzacm = new zzo(){

            @Override
            public void zzy(long l) {
                zzb.this.zza(zzb.this.zzq(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zza(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzq(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzUX;
        private final JSONObject zzaaU;

        zzc(Status status, JSONObject jSONObject) {
            this.zzUX = status;
            this.zzaaU = jSONObject;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzaaU;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzn {
        private GoogleApiClient zzaci;
        private long zzacj = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzaci = googleApiClient;
        }

        @Override
        public long zznQ() {
            return ++this.zzacj;
        }

        @Override
        public void zza(String string, String string2, long l, String string3) throws IOException {
            if (this.zzaci == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzaci, string, string2).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzack;

            zza(long l) {
                this.zzack = l;
            }

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzabE.zzb(this.zzack, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

