/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzlo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzli
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzci("com.google.cast.games");
    private static final zzl zzaaf = new zzl("GameManagerChannel");
    private final Map<String, String> zzacz = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzacA;
    private final SharedPreferences zzvx;
    private final String zzacB;
    private final Cast.CastApi zzacC;
    private final GoogleApiClient zzacD;
    private zzlj zzacE;
    private boolean zzacF = false;
    private GameManagerState zzacG;
    private GameManagerState zzacH;
    private String zzacI;
    private JSONObject zzacJ;
    private long zzacK = 0L;
    private GameManagerClient.Listener zzacL;
    private String zzacM;

    public zzli(GoogleApiClient googleApiClient, String string, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzacA = new ArrayList<zzp>();
        this.zzacB = string;
        this.zzacC = castApi;
        this.zzacD = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string2 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzvx = context.getApplicationContext().getSharedPreferences(string2, 0);
        this.zzacH = null;
        this.zzacG = new zzlm(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzacD.zzb((zza.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzli.this.zzacC.setMessageReceivedCallbacks(zzli.this.zzacD, zzli.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                            zzli.this.zzcf(message);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zznW().zza(-1L, 8, null);
                    return;
                }
                zzli.this.zznU();
                zzli.this.zznT();
                zzli.this.zza(null, 1100, null, this.zznW());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzacF) {
            return;
        }
        this.zzacG = null;
        this.zzacH = null;
        this.zzacI = null;
        this.zzacJ = null;
        this.zzacF = true;
        try {
            this.zzacC.removeMessageReceivedCallbacks(this.zzacD, this.getNamespace());
        }
        catch (IOException iOException) {
            zzaaf.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zznR();
        return this.zzacD.zzb((zza.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzll.zzbh(n);
                if (n2 == 0) {
                    this.zznW().zza(-1L, 2001, null);
                    zzaaf.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzli.this.zza(string, n2, jSONObject, this.zznW());
            }
        });
    }

    public synchronized void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zznR();
        long l = ++this.zzacK;
        JSONObject jSONObject = this.zza(l, playerId, 7, extraMessageData);
        if (jSONObject == null) {
            return;
        }
        this.zzacC.sendMessage(this.zzacD, this.getNamespace(), jSONObject.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String playerId, final JSONObject extraMessageData) throws IllegalStateException {
        this.zznR();
        return this.zzacD.zzb((zza.zza)new zza(){

            @Override
            public void execute() {
                zzli.this.zza(playerId, 6, extraMessageData, this.zznW());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zznR();
        return this.zzacG;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zznR();
        return this.zzacM;
    }

    public synchronized String zzce(String string) throws IllegalStateException {
        return string == null ? null : this.zzacz.get(string);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzacL = listener;
    }

    @Override
    public final void zzcf(String string) {
        boolean bl;
        zzlk zzlk2;
        zzaaf.zzb("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzlk2 = zzlk.zzi(jSONObject);
        }
        catch (JSONException jSONException) {
            zzaaf.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
            return;
        }
        if (zzlk2 == null) {
            zzaaf.zzf("Could not parse game manager message from string: %s", string);
            return;
        }
        if (!this.isInitialized() && zzlk2.zzod() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzlk2.zznY() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzlk2.zzoc())) {
            this.zzacz.put(zzlk2.getPlayerId(), zzlk2.zzoc());
            this.zznT();
        }
        if (zzlk2.getStatusCode() == 0) {
            this.zza(zzlk2);
        } else {
            zzaaf.zzf("Not updating from game message because the message contains error code: %d", zzlk2.getStatusCode());
        }
        int n = this.zzbg(zzlk2.getStatusCode());
        if (bl) {
            this.zzb(zzlk2.getRequestId(), n, zzlk2);
        }
        if (this.isInitialized() && n == 0) {
            this.zznS();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzacF;
    }

    public synchronized boolean isInitialized() {
        return this.zzacE != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        Iterator<zzp> iterator = this.zzacA.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zzaeB;
        synchronized (object) {
            for (zzp zzp3 : this.zzacA) {
                if (!zzp3.zzoA()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzbg(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzaaf.zzf("Unknown GameManager protocol status code: " + n, new Object[0]);
        return 13;
    }

    private synchronized void zznR() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string, int n, JSONObject jSONObject, zzo zzo2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzacK, string, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzaaf.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l, zzo2);
        this.zzacA.add(zzp2);
        this.zzW(true);
        this.zzacC.sendMessage(this.zzacD, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzli.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    private JSONObject zza(long l, String string, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string);
            jSONObject2.put("playerToken", (Object)this.zzce(string));
        }
        catch (JSONException jSONException) {
            zzaaf.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzlk zzlk2) {
        boolean bl = zzlk2.zznY() == 1;
        this.zzacH = this.zzacG;
        if (bl && zzlk2.zzod() != null) {
            this.zzacE = zzlk2.zzod();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzlo zzlo2 : zzlk2.zzoa()) {
            String string = zzlo2.getPlayerId();
            zzln zzln2 = new zzln(string, zzlo2.getPlayerState(), zzlo2.getPlayerData(), this.zzacz.containsKey(string));
            arrayList.add(zzln2);
        }
        this.zzacG = new zzlm(zzlk2.getLobbyState(), zzlk2.getGameplayState(), zzlk2.zzob(), zzlk2.getGameData(), arrayList, this.zzacE.zznX(), this.zzacE.getMaxPlayers());
        PlayerInfo playerInfo = this.zzacG.getPlayer(zzlk2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzlk2.zznY() == 2) {
            this.zzacI = zzlk2.getPlayerId();
            this.zzacJ = zzlk2.getExtraMessageData();
        }
    }

    private void zznS() {
        if (this.zzacL != null) {
            if (this.zzacH != null && !this.zzacG.equals(this.zzacH)) {
                this.zzacL.onStateChanged(this.zzacG, this.zzacH);
            }
            if (this.zzacJ != null && this.zzacI != null) {
                this.zzacL.onGameMessageReceived(this.zzacI, this.zzacJ);
            }
        }
        this.zzacH = null;
        this.zzacI = null;
        this.zzacJ = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzp> iterator = this.zzacA.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zznT() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzacB);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzacz));
            this.zzvx.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzaaf.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zznU() {
        String string = this.zzvx.getString("save_data", null);
        if (string == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("castSessionId");
            if (this.zzacB.equals(string2)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    this.zzacz.put(string3, jSONObject2.getString(string3));
                }
                this.zzacK = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzaaf.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzacm = new zzo(){

                @Override
                public void zzy(long l) {
                    zza.this.zza(zza.this.zzr(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zza(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzlk zzlk2 = (zzlk)object;
                        String string = zzlk2.getPlayerId();
                        if (n == 0 && string != null) {
                            zzli.this.zzacM = string;
                        }
                        zza.this.zza(new zze(new Status(n, zzlk2.zznZ(), null), string, zzlk2.getRequestId(), zzlk2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zza(zza.this.zzr(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzr(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzacV;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzacV = gameManagerClient;
            this.zzacm = new zzo(){

                @Override
                public void zzy(long l) {
                    zzc.this.zza(zzc.this.zzs(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zza(new zzd(new Status(n, null, null), zzc.this.zzacV));
                            return;
                        }
                        zzlk zzlk2 = (zzlk)object;
                        zzlj zzlj2 = zzlk2.zzod();
                        if (zzlj2 != null && !zzf.zza("1.0.0", zzlj2.getVersion())) {
                            zzc.this.zza(zzc.this.zzs(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzlj2.getVersion(), "1.0.0"))));
                            zzli.this.zzacE = null;
                            return;
                        }
                        zzc.this.zza(new zzd(new Status(n, zzlk2.zznZ(), null), zzc.this.zzacV));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zza(zzc.this.zzs(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzs(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzacm;

        public zzb() {
            super(zzli.this.zzacD);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zznW() {
            return this.zzacm;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzUX;
        private final String zzacX;
        private final long zzacY;
        private final JSONObject zzacZ;

        zze(Status status, String string, long l, JSONObject jSONObject) {
            this.zzUX = status;
            this.zzacX = string;
            this.zzacY = l;
            this.zzacZ = jSONObject;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public String getPlayerId() {
            return this.zzacX;
        }

        @Override
        public long getRequestId() {
            return this.zzacY;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzacZ;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzUX;
        private final GameManagerClient zzacV;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzUX = status;
            this.zzacV = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzacV;
        }
    }
}

