/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zzlm
implements GameManagerState {
    private final int zzadh;
    private final int zzadg;
    private final String zzadk;
    private final JSONObject zzadj;
    private final String zzada;
    private final int zzadb;
    private final Map<String, PlayerInfo> zzadm;

    public zzlm(int n, int n2, String string, JSONObject jSONObject, Collection<PlayerInfo> collection, String string2, int n3) {
        this.zzadh = n;
        this.zzadg = n2;
        this.zzadk = string;
        this.zzadj = jSONObject;
        this.zzada = string2;
        this.zzadb = n3;
        this.zzadm = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzadm.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public int getLobbyState() {
        return this.zzadh;
    }

    @Override
    public int getGameplayState() {
        return this.zzadg;
    }

    @Override
    public JSONObject getGameData() {
        return this.zzadj;
    }

    @Override
    public CharSequence getGameStatusText() {
        return this.zzadk;
    }

    @Override
    public CharSequence getApplicationName() {
        return this.zzada;
    }

    @Override
    public int getMaxPlayers() {
        return this.zzadb;
    }

    @Override
    public List<PlayerInfo> getPlayersInState(int playerState) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != playerState) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public PlayerInfo getPlayer(String playerId) {
        return playerId == null ? null : this.zzadm.get(playerId);
    }

    @Override
    public Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzadm.values());
    }

    @Override
    public List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public boolean hasLobbyStateChanged(GameManagerState other) {
        return this.zzadh != other.getLobbyState();
    }

    @Override
    public boolean hasGameplayStateChanged(GameManagerState other) {
        return this.zzadg != other.getGameplayState();
    }

    @Override
    public boolean hasGameDataChanged(GameManagerState other) {
        return !zznb.zze((Object)this.zzadj, (Object)other.getGameData());
    }

    @Override
    public boolean hasGameStatusTextChanged(GameManagerState other) {
        return !zzf.zza(this.zzadk, other.getGameStatusText());
    }

    @Override
    public boolean hasPlayerChanged(String playerId, GameManagerState other) {
        return !zzf.zza(this.getPlayer(playerId), other.getPlayer(playerId));
    }

    @Override
    public boolean hasPlayerStateChanged(String playerId, GameManagerState other) {
        PlayerInfo playerInfo = this.getPlayer(playerId);
        PlayerInfo playerInfo2 = other.getPlayer(playerId);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public boolean hasPlayerDataChanged(String playerId, GameManagerState other) {
        PlayerInfo playerInfo = this.getPlayer(playerId);
        PlayerInfo playerInfo2 = other.getPlayer(playerId);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zznb.zze((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public Collection<String> getListOfChangedPlayers(GameManagerState other) {
        PlayerInfo playerInfo;
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo2 : this.getPlayers()) {
            playerInfo = other.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null && playerInfo2.equals(playerInfo)) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        for (PlayerInfo playerInfo2 : other.getPlayers()) {
            playerInfo = this.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        return hashSet;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null || !(otherObj instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)otherObj;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzf.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzf.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzadh == gameManagerState.getLobbyState() && this.zzadg == gameManagerState.getGameplayState() && this.zzadb == gameManagerState.getMaxPlayers() && zzf.zza(this.zzada, gameManagerState.getApplicationName()) && zzf.zza(this.zzadk, gameManagerState.getGameStatusText()) && zznb.zze((Object)this.zzadj, (Object)gameManagerState.getGameData());
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzadh, this.zzadg, this.zzadm, this.zzadk, this.zzadj, this.zzada, this.zzadb});
    }
}

