/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzaeJ = new zzl("CastRemoteDisplayLocalService");
    private static final int zzaeK = CastRemoteDisplayLocalService.zzpJ();
    private static final Object zzaeL = new Object();
    private static AtomicBoolean zzaeM = new AtomicBoolean(false);
    private GoogleApiClient zzaeN;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzaeO;
    private String zzaeg;
    private Callbacks zzaeP;
    private zzb zzaeQ;
    private NotificationSettings zzaeR;
    private Notification mNotification;
    private boolean zzaeS;
    private PendingIntent zzaeT;
    private CastDevice zzaeU;
    private Display zzId;
    private Context zzaeV;
    private ServiceConnection zzaeW;
    private Handler mHandler;
    private MediaRouter zzaeX;
    private boolean zzaeY = false;
    private final MediaRouter.Callback zzaeZ = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            CastRemoteDisplayLocalService.this.zzbH("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzaeU == null) {
                CastRemoteDisplayLocalService.this.zzbH("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(routeInfo.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzaeU.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbH("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzafa;
    private final IBinder zzafb = new zza();

    private static int zzpJ() {
        return R.id.cast_notification_id;
    }

    public IBinder onBind(Intent intent) {
        this.zzbH("onBind");
        return this.zzafb;
    }

    public void onCreate() {
        this.zzbH("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean bl = CastRemoteDisplayLocalService.this.zzaeY;
                CastRemoteDisplayLocalService.this.zzbH(new StringBuilder(59).append("onCreate after delay. The local service been started: ").append(bl).toString());
                if (!CastRemoteDisplayLocalService.this.zzaeY) {
                    CastRemoteDisplayLocalService.this.zzbK("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzbH("onStartCommand");
        this.zzaeY = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzaeJ.zzag(true);
    }

    protected Display getDisplay() {
        return this.zzId;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzaeL;
        synchronized (object) {
            return zzafa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startService(final Context context, Class<? extends CastRemoteDisplayLocalService> clazz, final String string2, final CastDevice castDevice, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzaeJ.zzb("Starting Service", new Object[0]);
        Object object = zzaeL;
        synchronized (object) {
            if (zzafa != null) {
                zzaeJ.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzaa(true);
            }
        }
        CastRemoteDisplayLocalService.zza(context, clazz);
        zzaa.zzb((Object)context, (Object)"activityContext is required.");
        zzaa.zzb(clazz, (Object)"serviceClass is required.");
        zzaa.zzb((Object)string2, (Object)"applicationId is required.");
        zzaa.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzaa.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzaa.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzafi == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzaeM.getAndSet(true)) {
            zzaeJ.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)iBinder).zzpV();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(string2, castDevice, notificationSettings, context, this, callbacks)) {
                    zzaeJ.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzaeM.set(false);
                    try {
                        context.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzaeJ.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                zzaeJ.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzaeM.set(false);
                try {
                    context.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzaeJ.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzY(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzZ(bl);
                    }
                });
            } else {
                this.zzZ(bl);
            }
        }
    }

    private void zzZ(boolean bl) {
        this.zzbH("Stopping Service");
        zzaa.zzdc((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzaeX != null) {
            this.zzbH("Setting default route");
            this.zzaeX.selectRoute(this.zzaeX.getDefaultRoute());
        }
        if (this.zzaeQ != null) {
            this.zzbH("Unregistering notification receiver");
            this.unregisterReceiver(this.zzaeQ);
        }
        this.zzpO();
        this.zzpP();
        this.zzpK();
        if (this.zzaeN != null) {
            this.zzaeN.disconnect();
            this.zzaeN = null;
        }
        if (this.zzaeV != null && this.zzaeW != null) {
            try {
                this.zzaeV.unbindService(this.zzaeW);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbH("No need to unbind service, already unbound");
            }
            this.zzaeW = null;
            this.zzaeV = null;
        }
        this.zzaeg = null;
        this.zzaeN = null;
        this.mNotification = null;
        this.zzId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzaa(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzaeJ.zzb("Stopping Service", new Object[0]);
        zzaeM.set(false);
        Object object = zzaeL;
        synchronized (object) {
            if (zzafa == null) {
                zzaeJ.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzafa;
            zzafa = null;
        }
        castRemoteDisplayLocalService.zzY(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzaa(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzaa.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzaa.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzaa.zzdc((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzaeR == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzaeS) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzafi != null) {
                this.zzaeR.zzafi = notificationSettings.zzafi;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzafj)) {
                this.zzaeR.zzafj = notificationSettings.zzafj;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzafk)) {
                this.zzaeR.zzafk = notificationSettings.zzafk;
            }
            this.mNotification = this.zzab(true);
        } else {
            zzaa.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzaeR.mNotification = this.mNotification;
        }
        this.startForeground(zzaeK, this.mNotification);
    }

    private static void zza(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzId = display;
        if (this.zzaeS) {
            this.mNotification = this.zzab(true);
            this.startForeground(zzaeK, this.mNotification);
        }
        if (this.zzaeP != null) {
            this.zzaeP.onRemoteDisplaySessionStarted(this);
            this.zzaeP = null;
        }
        this.onCreatePresentation(this.zzId);
    }

    private void zzpK() {
        if (this.zzaeX != null) {
            zzaa.zzdc((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbH("removeMediaRouterCallback");
            this.zzaeX.removeCallback(this.zzaeZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbH("startRemoteDisplaySession");
        zzaa.zzdc((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzaeL;
        synchronized (object) {
            if (zzafa != null) {
                zzaeJ.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzafa = this;
        }
        this.zzaeP = callbacks;
        this.zzaeg = string2;
        this.zzaeU = castDevice;
        this.zzaeV = context;
        this.zzaeW = serviceConnection;
        this.zzaeX = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzaeg)).build();
        this.zzbH("addMediaRouterCallback");
        this.zzaeX.addCallback((MediaRouteSelector)object, this.zzaeZ, 4);
        this.zzaeO = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzaeJ.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzaa(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.zzaeQ = new zzb();
        this.registerReceiver(this.zzaeQ, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzaeR = new NotificationSettings(notificationSettings);
        if (this.zzaeR.mNotification == null) {
            this.zzaeS = true;
            this.mNotification = this.zzab(false);
        } else {
            this.zzaeS = false;
            this.mNotification = this.zzaeR.mNotification;
        }
        this.startForeground(zzaeK, this.mNotification);
        this.zzaeN = this.zza(castDevice);
        this.zzaeN.connect();
        if (this.zzaeP != null) {
            this.zzaeP.onServiceCreated(this);
        }
        return true;
    }

    private void zzpL() {
        this.zzbH("startRemoteDisplay");
        if (this.zzaeN == null || !this.zzaeN.isConnected()) {
            zzaeJ.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzaeN, this.zzaeg).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzaeJ.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzpN();
                    return;
                }
                zzaeJ.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzaeL;
                synchronized (object) {
                    if (zzafa == null) {
                        zzaeJ.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzpN();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzaeJ.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzaeM.set(false);
                if (CastRemoteDisplayLocalService.this.zzaeV != null && CastRemoteDisplayLocalService.this.zzaeW != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzaeV.unbindService(CastRemoteDisplayLocalService.this.zzaeW);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzaeJ.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzaeW = null;
                    CastRemoteDisplayLocalService.this.zzaeV = null;
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzpM() {
        this.zzbH("stopRemoteDisplay");
        if (this.zzaeN == null || !this.zzaeN.isConnected()) {
            zzaeJ.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzaeN).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbH("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbH("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzId = null;
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzpN() {
        if (this.zzaeP != null) {
            this.zzaeP.onRemoteDisplaySessionError(new Status(2200));
            this.zzaeP = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzpO() {
        this.zzbH("stopRemoteDisplaySession");
        this.zzpM();
        this.onDismissPresentation();
    }

    private void zzpP() {
        this.zzbH("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzaeO);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbH("onConnected");
                CastRemoteDisplayLocalService.this.zzpL();
            }

            public void onConnectionSuspended(int n) {
                zzaeJ.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, n), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                String string2 = String.valueOf(connectionResult);
                CastRemoteDisplayLocalService.this.zzbK(new StringBuilder(19 + String.valueOf(string2).length()).append("Connection failed: ").append(string2).toString());
                CastRemoteDisplayLocalService.this.zzpN();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzpQ() {
        if (this.zzaeT == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(this.zzaeV.getPackageName());
            this.zzaeT = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzaeT;
    }

    private Notification zzab(boolean bl) {
        int n;
        int n2;
        this.zzbH("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzaeR.zzafj;
        String string3 = this.zzaeR.zzafk;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzaeU.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzaeR.zzafi).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzpQ()).build();
        return notification;
    }

    private void zzbH(String string2) {
        zzaeJ.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbK(String string2) {
        zzaeJ.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzpV() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzaeJ.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzafi;
        private String zzafj;
        private String zzafk;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzafi = notificationSettings.zzafi;
            this.zzafj = notificationSettings.zzafj;
            this.zzafk = notificationSettings.zzafk;
        }

        public static final class Builder {
            private NotificationSettings zzafl = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzafl.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzafl.zzafi = pendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String string2) {
                this.zzafl.zzafj = string2;
                return this;
            }

            public Builder setNotificationText(String string2) {
                this.zzafl.zzafk = string2;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzafl.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzafl.zzafj)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzafl.zzafk)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzafl.zzafi != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzafl.zzafj) && TextUtils.isEmpty((CharSequence)this.zzafl.zzafk) && this.zzafl.zzafi == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzafl;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

