/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzp;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzafp;
    private int zzafq;
    private String zzafr;
    private MediaMetadata zzafs;
    private long zzaft;
    private List<MediaTrack> zzafu;
    private TextTrackStyle zzafv;
    private JSONObject zzafw;

    MediaInfo(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzafp = string2;
        this.zzafq = -1;
        this.zzaft = -1L;
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject2;
        this.zzafp = jSONObject.getString("contentId");
        String string2 = jSONObject.getString("streamType");
        this.zzafq = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzafr = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzafs = new MediaMetadata(n);
            this.zzafs.zzi(jSONObject2);
        }
        this.zzaft = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzaft = zzf.zzg(d);
        }
        if (jSONObject.has("tracks")) {
            this.zzafu = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzafu.add(mediaTrack);
            }
        } else {
            this.zzafu = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzi(jSONObject2);
            this.zzafv = textTrackStyle;
        } else {
            this.zzafv = null;
        }
        this.zzafw = jSONObject.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzafp;
    }

    void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzafq = n;
    }

    public int getStreamType() {
        return this.zzafq;
    }

    void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzafr = string2;
    }

    public String getContentType() {
        return this.zzafr;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzafs = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzafs;
    }

    void zzz(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzaft = l;
    }

    public long getStreamDuration() {
        return this.zzaft;
    }

    void zzw(List<MediaTrack> list) {
        this.zzafu = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzafu;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzafv = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzafv;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzafw = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzafw;
    }

    void zzpW() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzafp)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzafr)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzafq == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzafp);
            switch (this.zzafq) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzafr != null) {
                jSONObject.put("contentType", (Object)this.zzafr);
            }
            if (this.zzafs != null) {
                jSONObject.put("metadata", (Object)this.zzafs.toJson());
            }
            if (this.zzaft <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzC(this.zzaft));
            }
            if (this.zzafu != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzafu) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzafv != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzafv.toJson());
            }
            if (this.zzafw != null) {
                jSONObject.put("customData", (Object)this.zzafw);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)object;
        if (this.zzafw == null != (mediaInfo.zzafw == null)) {
            return false;
        }
        if (this.zzafw != null && mediaInfo.zzafw != null && !zzp.zzf((Object)this.zzafw, (Object)mediaInfo.zzafw)) {
            return false;
        }
        return zzf.zza(this.zzafp, mediaInfo.zzafp) && this.zzafq == mediaInfo.zzafq && zzf.zza(this.zzafr, mediaInfo.zzafr) && zzf.zza(this.zzafs, mediaInfo.zzafs) && this.zzaft == mediaInfo.zzaft;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzafp, this.zzafq, this.zzafr, this.zzafs, this.zzaft, String.valueOf(this.zzafw)});
    }

    public static class Builder {
        private final MediaInfo zzafx;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzafx = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzafx.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzafx.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzafx.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzafx.zzz(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzafx.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzafx.zzw(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzafx.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzafx.zzpW();
            return this.zzafx;
        }
    }
}

