/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzafF;
    private int zzafG = 0;
    private boolean zzafH = true;
    private double zzafI;
    private double zzafJ = Double.POSITIVE_INFINITY;
    private double zzafK;
    private long[] zzafL;
    private JSONObject zzafw;

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzafF = mediaInfo;
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this.zzj(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this.zzafF = mediaQueueItem.getMedia();
        if (this.zzafF == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzafG = mediaQueueItem.getItemId();
        this.zzafH = mediaQueueItem.getAutoplay();
        this.zzafI = mediaQueueItem.getStartTime();
        this.zzafJ = mediaQueueItem.getPlaybackDuration();
        this.zzafK = mediaQueueItem.getPreloadTime();
        this.zzafL = mediaQueueItem.getActiveTrackIds();
        this.zzafw = mediaQueueItem.getCustomData();
    }

    public boolean zzj(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzafF = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzafG != (n = jSONObject.getInt("itemId"))) {
            this.zzafG = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzafH != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzafH = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzafI) > 1.0E-7) {
            this.zzafI = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzafJ) > 1.0E-7) {
            this.zzafJ = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzafK) > 1.0E-7) {
            this.zzafK = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzafL == null) {
                bl2 = true;
            } else if (this.zzafL.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzafL[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzafL = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzafw = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzafF;
    }

    public int getItemId() {
        return this.zzafG;
    }

    void zzbh(int n) {
        this.zzafG = n;
    }

    public boolean getAutoplay() {
        return this.zzafH;
    }

    void zzad(boolean bl) {
        this.zzafH = bl;
    }

    public double getStartTime() {
        return this.zzafI;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzafI = d;
    }

    public double getPlaybackDuration() {
        return this.zzafJ;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzafJ = d;
    }

    public double getPreloadTime() {
        return this.zzafK;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzafK = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzafL;
    }

    void zza(long[] lArray) {
        this.zzafL = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzafw;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzafw = jSONObject;
    }

    void zzpW() throws IllegalArgumentException {
        if (this.zzafF == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzafI) || this.zzafI < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzafJ)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzafK) || this.zzafK < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzafF.toJson());
            if (this.zzafG != 0) {
                jSONObject.put("itemId", this.zzafG);
            }
            jSONObject.put("autoplay", this.zzafH);
            jSONObject.put("startTime", this.zzafI);
            if (this.zzafJ != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzafJ);
            }
            jSONObject.put("preloadTime", this.zzafK);
            if (this.zzafL != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzafL) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzafw != null) {
                jSONObject.put("customData", (Object)this.zzafw);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)object;
        if (this.zzafw == null != (mediaQueueItem.zzafw == null)) {
            return false;
        }
        if (this.zzafw != null && mediaQueueItem.zzafw != null && !zzp.zzf((Object)this.zzafw, (Object)mediaQueueItem.zzafw)) {
            return false;
        }
        return zzf.zza(this.zzafF, mediaQueueItem.zzafF) && this.zzafG == mediaQueueItem.zzafG && this.zzafH == mediaQueueItem.zzafH && this.zzafI == mediaQueueItem.zzafI && this.zzafJ == mediaQueueItem.zzafJ && this.zzafK == mediaQueueItem.zzafK && zzf.zza(this.zzafL, mediaQueueItem.zzafL);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzafF, this.zzafG, this.zzafH, this.zzafI, this.zzafJ, this.zzafK, this.zzafL, String.valueOf(this.zzafw)});
    }

    public static class Builder {
        private final MediaQueueItem zzafM;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzafM = new MediaQueueItem(mediaInfo);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzafM = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzafM = new MediaQueueItem(mediaQueueItem);
        }

        public Builder clearItemId() {
            this.zzafM.zzbh(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzafM.zzad(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzafM.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzafM.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzafM.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzafM.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzafM.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzafM.zzpW();
            return this.zzafM;
        }
    }
}

