/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzne;
import com.google.android.gms.internal.zznt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzmy
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzcF("com.google.cast.games");
    private static final zzl zzaeJ = new zzl("GameManagerChannel");
    private final Map<String, String> zzahb = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzahc;
    private final SharedPreferences zzwV;
    private final String zzahd;
    private final Cast.CastApi zzahe;
    private final GoogleApiClient zzahf;
    private zzmz zzahg;
    private boolean zzahh = false;
    private GameManagerState zzahi;
    private GameManagerState zzahj;
    private String zzahk;
    private JSONObject zzahl;
    private long zzahm = 0L;
    private GameManagerClient.Listener zzahn;
    private String zzaho;

    public zzmy(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzahc = new ArrayList<zzp>();
        this.zzahd = string2;
        this.zzahe = castApi;
        this.zzahf = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzwV = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzahj = null;
        this.zzahi = new zznc(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzahf.zzd((zznt.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzmy.this.zzahe.setMessageReceivedCallbacks(zzmy.this.zzahf, zzmy.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
                            zzmy.this.zzcC(string3);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzqf().zza(-1L, 8, null);
                    return;
                }
                zzmy.this.zzqd();
                zzmy.this.zzqc();
                zzmy.this.zza(null, 1100, null, this.zzqf());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzahh) {
            return;
        }
        this.zzahi = null;
        this.zzahj = null;
        this.zzahk = null;
        this.zzahl = null;
        this.zzahh = true;
        try {
            this.zzahe.removeMessageReceivedCallbacks(this.zzahf, this.getNamespace());
        }
        catch (IOException iOException) {
            zzaeJ.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzqa();
        return this.zzahf.zzd((zznt.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zznb.zzbo(n);
                if (n2 == 0) {
                    this.zzqf().zza(-1L, 2001, null);
                    zzaeJ.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzmy.this.zza(string2, n2, jSONObject, this.zzqf());
            }
        });
    }

    public synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzqa();
        long l = ++this.zzahm;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzahe.sendMessage(this.zzahf, this.getNamespace(), jSONObject2.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String string2, final JSONObject jSONObject) throws IllegalStateException {
        this.zzqa();
        return this.zzahf.zzd((zznt.zza)new zza(){

            @Override
            public void execute() {
                zzmy.this.zza(string2, 6, jSONObject, this.zzqf());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzqa();
        return this.zzahi;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzqa();
        return this.zzaho;
    }

    public synchronized String zzcB(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzahb.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzahn = listener;
    }

    @Override
    public final void zzcC(String string2) {
        boolean bl;
        zzna zzna2;
        zzaeJ.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzna2 = zzna.zzk(jSONObject);
        }
        catch (JSONException jSONException) {
            zzaeJ.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzna2 == null) {
            zzaeJ.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzna2.zzqm() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzna2.zzqh() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzna2.zzql())) {
            this.zzahb.put(zzna2.getPlayerId(), zzna2.zzql());
            this.zzqc();
        }
        if (zzna2.getStatusCode() == 0) {
            this.zza(zzna2);
        } else {
            zzaeJ.zzf("Not updating from game message because the message contains error code: %d", zzna2.getStatusCode());
        }
        int n = this.zzbn(zzna2.getStatusCode());
        if (bl) {
            this.zzb(zzna2.getRequestId(), n, zzna2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzqb();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzahh;
    }

    public synchronized boolean isInitialized() {
        return this.zzahg != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzB(long l) {
        Iterator<zzp> iterator = this.zzahc.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zznS;
        synchronized (object) {
            for (zzp zzp3 : this.zzahc) {
                if (!zzp3.zzqK()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzbn(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzaeJ.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n).toString(), new Object[0]);
        return 13;
    }

    private synchronized void zzqa() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzo zzo2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzahm, string2, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzaeJ.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l, zzo2);
        this.zzahc.add(zzp2);
        this.zzae(true);
        this.zzahe.sendMessage(this.zzahf, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzo(Status status) {
                if (!status.isSuccess()) {
                    zzmy.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzo((Status)result);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzcB(string2));
        }
        catch (JSONException jSONException) {
            zzaeJ.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzna zzna2) {
        boolean bl = zzna2.zzqh() == 1;
        this.zzahj = this.zzahi;
        if (bl && zzna2.zzqm() != null) {
            this.zzahg = zzna2.zzqm();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzne zzne2 : zzna2.zzqj()) {
            String string2 = zzne2.getPlayerId();
            zznd zznd2 = new zznd(string2, zzne2.getPlayerState(), zzne2.getPlayerData(), this.zzahb.containsKey(string2));
            arrayList.add(zznd2);
        }
        this.zzahi = new zznc(zzna2.getLobbyState(), zzna2.getGameplayState(), zzna2.zzqk(), zzna2.getGameData(), arrayList, this.zzahg.zzqg(), this.zzahg.getMaxPlayers());
        PlayerInfo playerInfo = this.zzahi.getPlayer(zzna2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzna2.zzqh() == 2) {
            this.zzahk = zzna2.getPlayerId();
            this.zzahl = zzna2.getExtraMessageData();
        }
    }

    private void zzqb() {
        if (this.zzahn != null) {
            if (this.zzahj != null && !this.zzahi.equals(this.zzahj)) {
                this.zzahn.onStateChanged(this.zzahi, this.zzahj);
            }
            if (this.zzahl != null && this.zzahk != null) {
                this.zzahn.onGameMessageReceived(this.zzahk, this.zzahl);
            }
        }
        this.zzahj = null;
        this.zzahk = null;
        this.zzahl = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzp> iterator = this.zzahc.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzqc() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzahd);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzahb));
            this.zzwV.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzaeJ.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzqd() {
        String string2 = this.zzwV.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzahd.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzahb.put(string4, jSONObject2.getString(string4));
                }
                this.zzahm = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzaeJ.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzagO = new zzo(){

                @Override
                public void zzA(long l) {
                    zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzb(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzna zzna2 = (zzna)object;
                        String string2 = zzna2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzmy.this.zzaho = string2;
                        }
                        zza.this.zzb(new zze(new Status(n, zzna2.zzqi(), null), string2, zzna2.getRequestId(), zzna2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzq(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzahx;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzahx = gameManagerClient;
            this.zzagO = new zzo(){

                @Override
                public void zzA(long l) {
                    zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzb(new zzd(new Status(n, null, null), zzc.this.zzahx));
                            return;
                        }
                        zzna zzna2 = (zzna)object;
                        zzmz zzmz2 = zzna2.zzqm();
                        if (zzmz2 != null && !zzf.zza("1.0.0", zzmz2.getVersion())) {
                            zzmy.this.zzahg = null;
                            zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzmz2.getVersion(), "1.0.0"))));
                            return;
                        }
                        zzc.this.zzb(new zzd(new Status(n, zzna2.zzqi(), null), zzc.this.zzahx));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzr(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzagO;

        public zzb() {
            super(zzmy.this.zzahf);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zzqf() {
            return this.zzagO;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzaaO;
        private final String zzahz;
        private final long zzahA;
        private final JSONObject zzahB;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.zzaaO = status;
            this.zzahz = string2;
            this.zzahA = l;
            this.zzahB = jSONObject;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getPlayerId() {
            return this.zzahz;
        }

        @Override
        public long getRequestId() {
            return this.zzahA;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzahB;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzaaO;
        private final GameManagerClient zzahx;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzaaO = status;
            this.zzahx = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzahx;
        }
    }
}

