/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zznc
implements GameManagerState {
    private final int zzahJ;
    private final int zzahI;
    private final String zzahM;
    private final JSONObject zzahL;
    private final String zzahC;
    private final int zzahD;
    private final Map<String, PlayerInfo> zzahO;

    public zznc(int n, int n2, String string2, JSONObject jSONObject, Collection<PlayerInfo> collection, String string3, int n3) {
        this.zzahJ = n;
        this.zzahI = n2;
        this.zzahM = string2;
        this.zzahL = jSONObject;
        this.zzahC = string3;
        this.zzahD = n3;
        this.zzahO = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzahO.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public int getLobbyState() {
        return this.zzahJ;
    }

    @Override
    public int getGameplayState() {
        return this.zzahI;
    }

    @Override
    public JSONObject getGameData() {
        return this.zzahL;
    }

    @Override
    public CharSequence getGameStatusText() {
        return this.zzahM;
    }

    @Override
    public CharSequence getApplicationName() {
        return this.zzahC;
    }

    @Override
    public int getMaxPlayers() {
        return this.zzahD;
    }

    @Override
    public List<PlayerInfo> getPlayersInState(int n) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != n) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public PlayerInfo getPlayer(String string2) {
        return string2 == null ? null : this.zzahO.get(string2);
    }

    @Override
    public Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzahO.values());
    }

    @Override
    public List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public boolean hasLobbyStateChanged(GameManagerState gameManagerState) {
        return this.zzahJ != gameManagerState.getLobbyState();
    }

    @Override
    public boolean hasGameplayStateChanged(GameManagerState gameManagerState) {
        return this.zzahI != gameManagerState.getGameplayState();
    }

    @Override
    public boolean hasGameDataChanged(GameManagerState gameManagerState) {
        return !zzp.zzf((Object)this.zzahL, (Object)gameManagerState.getGameData());
    }

    @Override
    public boolean hasGameStatusTextChanged(GameManagerState gameManagerState) {
        return !zzf.zza(this.zzahM, gameManagerState.getGameStatusText());
    }

    @Override
    public boolean hasPlayerChanged(String string2, GameManagerState gameManagerState) {
        return !zzf.zza(this.getPlayer(string2), gameManagerState.getPlayer(string2));
    }

    @Override
    public boolean hasPlayerStateChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public boolean hasPlayerDataChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zzp.zzf((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public Collection<String> getListOfChangedPlayers(GameManagerState gameManagerState) {
        PlayerInfo playerInfo;
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo2 : this.getPlayers()) {
            playerInfo = gameManagerState.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null && playerInfo2.equals(playerInfo)) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
            playerInfo = this.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)object;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzf.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzf.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzahJ == gameManagerState.getLobbyState() && this.zzahI == gameManagerState.getGameplayState() && this.zzahD == gameManagerState.getMaxPlayers() && zzf.zza(this.zzahC, gameManagerState.getApplicationName()) && zzf.zza(this.zzahM, gameManagerState.getGameStatusText()) && zzp.zzf((Object)this.zzahL, (Object)gameManagerState.getGameData());
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzahJ, this.zzahI, this.zzahO, this.zzahM, this.zzahL, this.zzahC, this.zzahD});
    }
}

