/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ApplicationMetadata
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int mVersionCode;
    String zzaeg;
    String mName;
    List<WebImage> zzAD;
    List<String> zzaeh;
    String zzaei;
    Uri zzaej;

    ApplicationMetadata(int n, String string, String string2, List<WebImage> list, List<String> list2, String string3, Uri uri) {
        this.mVersionCode = n;
        this.zzaeg = string;
        this.mName = string2;
        this.zzAD = list;
        this.zzaeh = list2;
        this.zzaei = string3;
        this.zzaej = uri;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzAD = new ArrayList<WebImage>();
        this.zzaeh = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzaeg;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String string) {
        return this.zzaeh != null && this.zzaeh.contains(string);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzaeh);
    }

    public boolean areNamespacesSupported(List<String> list) {
        return this.zzaeh != null && this.zzaeh.containsAll(list);
    }

    public String getSenderAppIdentifier() {
        return this.zzaei;
    }

    public Uri zzpF() {
        return this.zzaej;
    }

    public List<WebImage> getImages() {
        return this.zzAD;
    }

    public String toString() {
        return "applicationId: " + this.zzaeg + ", name: " + this.mName + ", images.count: " + (this.zzAD == null ? 0 : this.zzAD.size()) + ", namespaces.count: " + (this.zzaeh == null ? 0 : this.zzaeh.size()) + ", senderAppIdentifier: " + this.zzaei + ", senderAppLaunchUrl: " + this.zzaej;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.mVersionCode, this.zzaeg, this.mName, this.zzAD, this.zzaeh, this.zzaei, this.zzaej});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)((Object)object);
        return zzf.zza(this.zzaeg, applicationMetadata.zzaeg) && zzf.zza(this.zzAD, applicationMetadata.zzAD) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzaeh, applicationMetadata.zzaeh) && zzf.zza(this.zzaei, applicationMetadata.zzaei) && zzf.zza(this.zzaej, applicationMetadata.zzaej);
    }
}

