/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends AbstractSafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int mVersionCode;
    private String zzaex;
    String zzaey;
    private Inet4Address zzaez;
    private String zzaeA;
    private String zzaeB;
    private String zzaeC;
    private int zzaeD;
    private List<WebImage> zzaeE;
    private int zzaeF;
    private int zzDO;
    private String zzaeG;

    CastDevice(int n, String string, String string2, String string3, String string4, String string5, int n2, List<WebImage> arrayList, int n3, int n4, String string6) {
        this.mVersionCode = n;
        this.zzaex = CastDevice.zzcw(string);
        this.zzaey = CastDevice.zzcw(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzaey)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzaey);
                if (inetAddress instanceof Inet4Address) {
                    this.zzaez = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string7 = this.zzaey;
                String string8 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Unable to convert host address (").append(string7).append(") to ipaddress: ").append(string8).toString());
            }
        }
        this.zzaeA = CastDevice.zzcw(string3);
        this.zzaeB = CastDevice.zzcw(string4);
        this.zzaeC = CastDevice.zzcw(string5);
        this.zzaeD = n2;
        this.zzaeE = arrayList != null ? arrayList : new ArrayList();
        this.zzaeF = n3;
        this.zzDO = n4;
        this.zzaeG = CastDevice.zzcw(string6);
    }

    private CastDevice() {
        this(4, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1, null);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        if (this.zzaex.startsWith("__cast_nearby__")) {
            return this.zzaex.substring("__cast_nearby__".length() + 1);
        }
        return this.zzaex;
    }

    public String zzpG() {
        return this.zzaex;
    }

    public Inet4Address getIpAddress() {
        return this.zzaez;
    }

    public String getFriendlyName() {
        return this.zzaeA;
    }

    public String getModelName() {
        return this.zzaeB;
    }

    public String getDeviceVersion() {
        return this.zzaeC;
    }

    public String zzpH() {
        return this.zzaeG;
    }

    public int getServicePort() {
        return this.zzaeD;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzaeE);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzaeE.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzaeE.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzaeE) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzaeE.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzaeE.isEmpty();
    }

    public int getCapabilities() {
        return this.zzaeF;
    }

    public boolean hasCapability(int n) {
        return (this.zzaeF & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int n : nArray) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzDO;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzaeA, this.zzaex);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzaex == null) {
            return castDevice.zzaex == null;
        }
        return zzf.zza(this.zzaex, castDevice.zzaex) && zzf.zza(this.zzaez, castDevice.zzaez) && zzf.zza(this.zzaeB, castDevice.zzaeB) && zzf.zza(this.zzaeA, castDevice.zzaeA) && zzf.zza(this.zzaeC, castDevice.zzaeC) && this.zzaeD == castDevice.zzaeD && zzf.zza(this.zzaeE, castDevice.zzaeE) && this.zzaeF == castDevice.zzaeF && this.zzDO == castDevice.zzDO && zzf.zza(this.zzaeG, castDevice.zzaeG);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzaex == null) {
            return castDevice.zzaex == null;
        }
        return zzf.zza(this.zzaex, castDevice.zzaex);
    }

    public int hashCode() {
        return this.zzaex == null ? 0 : this.zzaex.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzaex.startsWith("__cast_nearby__");
    }

    private static String zzcw(String string) {
        return string == null ? "" : string;
    }
}

