/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznt;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

@SuppressLint(value={"MissingRemoteException"})
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzpp = new Object();
    private final zzm zzagg;
    private final zza zzagh;
    private OnPreloadStatusUpdatedListener zzagi;
    private OnQueueStatusUpdatedListener zzagj;
    private OnMetadataUpdatedListener zzagk;
    private OnStatusUpdatedListener zzagl;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this(new zzm(null));
    }

    RemoteMediaPlayer(zzm zzm2) {
        this.zzagg = zzm2;
        this.zzagg.zza(new zzm.zza(){

            @Override
            public void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            public void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            public void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            public void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }
        });
        this.zzagh = new zza();
        this.zzagg.zza(this.zzagh);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo) {
        return this.load(googleApiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl) {
        return this.load(googleApiClient, mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient googleApiClient, final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient googleApiClient) {
        return this.pause(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient googleApiClient) {
        return this.stop(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zzb(this.zzagO, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient googleApiClient) {
        return this.play(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zzc(this.zzagO, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l) {
        return this.seek(googleApiClient, l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l, int n) {
        return this.seek(googleApiClient, l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient googleApiClient, final long l, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, l, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient googleApiClient, double d) throws IllegalArgumentException {
        return this.setStreamVolume(googleApiClient, d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient googleApiClient, final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, d, jSONObject);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient googleApiClient, boolean bl) {
        return this.setStreamMute(googleApiClient, bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient googleApiClient, final boolean bl, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, bl, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient googleApiClient, final long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, lArray);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient googleApiClient, final TextTrackStyle textTrackStyle) {
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, textTrackStyle);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient googleApiClient, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(googleApiClient, mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(googleApiClient, new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(googleApiClient, mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient googleApiClient, final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient googleApiClient, final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, nArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient googleApiClient, final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, nArray, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, 0, -1L, null, 0, (Integer)n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbm(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, new int[]{n}, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient googleApiClient, int n, JSONObject jSONObject) {
        return this.queueJumpToItem(googleApiClient, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient googleApiClient, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbm(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, n, l, null, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient googleApiClient, final int n, final int n2, final JSONObject jSONObject) {
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpp;
                synchronized (object) {
                    int n4 = RemoteMediaPlayer.this.zzbm(n);
                    if (n4 == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzagh.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzagg.zza(this.zzagO, new int[]{n}, n3, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzagh.zzc(null);
                    }
                }
            }
        });
    }

    private int zzbm(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzagg.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzagg.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzagg.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzagg.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener onStatusUpdatedListener) {
        this.zzagl = onStatusUpdatedListener;
    }

    private void onStatusUpdated() {
        if (this.zzagl != null) {
            this.zzagl.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener onMetadataUpdatedListener) {
        this.zzagk = onMetadataUpdatedListener;
    }

    private void onMetadataUpdated() {
        if (this.zzagk != null) {
            this.zzagk.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener onQueueStatusUpdatedListener) {
        this.zzagj = onQueueStatusUpdatedListener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzagj != null) {
            this.zzagj.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener onPreloadStatusUpdatedListener) {
        this.zzagi = onPreloadStatusUpdatedListener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzagi != null) {
            this.zzagi.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzagg.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzagg.zzcC(string3);
    }

    static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzo zzagO = new zzo(){

            @Override
            public void zzA(long l) {
                zzb.this.zzb((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzp(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zze zze2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzp(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzaaO;
        private final JSONObject zzafw;

        zzc(Status status, JSONObject jSONObject) {
            this.zzaaO = status;
            this.zzafw = jSONObject;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzafw;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzn {
        private GoogleApiClient zzagK;
        private long zzagL = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzagK = googleApiClient;
        }

        @Override
        public long zzpZ() {
            return ++this.zzagL;
        }

        @Override
        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzagK == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzagK, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzagM;

            zza(long l) {
                this.zzagM = l;
            }

            public void zzo(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzagg.zzb(this.zzagM, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzo((Status)result);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

