/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.internal.zznt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class zze
extends zzk<zzi> {
    private static final zzl zzaeJ = new zzl("CastClientImpl");
    private ApplicationMetadata zzahZ;
    private final CastDevice zzaia;
    private final Cast.Listener zzaet;
    private final Map<String, Cast.MessageReceivedCallback> zzaib;
    private final long zzaic;
    private zzb zzaid;
    private String zzaie;
    private boolean zzafV;
    private boolean zzaif;
    private boolean zzaig;
    private boolean zzaih;
    private double zzafU;
    private int zzaii;
    private int zzaij;
    private final AtomicLong zzaik;
    private String zzail;
    private String zzaim;
    private Bundle zzain;
    private final Map<Long, zznt.zzb<Status>> zzaio;
    private zzi zzaip;
    private zznt.zzb<Cast.ApplicationConnectionResult> zzaiq;
    private zznt.zzb<Status> zzair;
    private static final Object zzais = new Object();
    private static final Object zzait = new Object();

    public zze(Context context, Looper looper, zzg zzg2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaia = castDevice;
        this.zzaet = listener;
        this.zzaic = l;
        this.zzaib = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzaik = new AtomicLong(0L);
        this.zzaio = new HashMap<Long, zznt.zzb<Status>>();
        this.zzqq();
    }

    private void zzqq() {
        this.zzaih = false;
        this.zzaii = -1;
        this.zzaij = -1;
        this.zzahZ = null;
        this.zzaie = null;
        this.zzafU = 0.0;
        this.zzafV = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzaeJ.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzaih = true;
            this.zzaif = true;
            this.zzaig = true;
        } else {
            this.zzaih = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzain = new Bundle();
            this.zzain.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public void disconnect() {
        zzaeJ.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzaid, this.isConnected());
        zzb zzb2 = this.zzaid;
        this.zzaid = null;
        if (zzb2 == null || zzb2.zzqC() == null) {
            zzaeJ.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzqx();
        try {
            this.zzqs().disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzaeJ.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzqr() {
        if (this.zzain != null) {
            Bundle bundle = this.zzain;
            this.zzain = null;
            return bundle;
        }
        return super.zzqr();
    }

    @NonNull
    protected String zzhT() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected String zzhU() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaI(IBinder iBinder) {
        return zzi.zza.zzaJ(iBinder);
    }

    protected Bundle zzoO() {
        Bundle bundle = new Bundle();
        zzaeJ.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzail, this.zzaim);
        this.zzaia.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzaic);
        this.zzaid = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzaid.asBinder()));
        if (this.zzail != null) {
            bundle.putString("last_application_id", this.zzail);
            if (this.zzaim != null) {
                bundle.putString("last_session_id", this.zzaim);
            }
        }
        return bundle;
    }

    zzi zzqs() throws DeadObjectException {
        return null == null ? (zzi)super.zztm() : this.zzaip;
    }

    public void zza(String string2, String string3, zznt.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzcE(string2);
        this.zzqy();
        long l = this.zzaik.incrementAndGet();
        try {
            this.zzaio.put(l, zzb2);
            this.zzqs().zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzaio.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zznt.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.setRelaunchIfRunning(bl);
        this.zza(string2, launchOptions, zzb2);
    }

    public void zza(String string2, LaunchOptions launchOptions, zznt.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        this.zzqs().zza(string2, launchOptions);
    }

    public void zza(String string2, String string3, JoinOptions joinOptions, zznt.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (joinOptions == null) {
            joinOptions = new JoinOptions();
        }
        this.zzqs().zza(string2, string3, joinOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zznt.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzais;
        synchronized (object) {
            if (this.zzaiq != null) {
                this.zzaiq.setResult((Object)new zza(new Status(2002)));
            }
            this.zzaiq = zzb2;
        }
    }

    public void zzb(zznt.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzqs().zzqE();
    }

    public void zza(String string2, zznt.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzqs().zzcH(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zznt.zzb<Status> zzb2) {
        Object object = zzait;
        synchronized (object) {
            if (this.zzair != null) {
                zzb2.setResult((Object)new Status(2001));
                return;
            }
            this.zzair = zzb2;
        }
    }

    public void zzqt() throws IllegalStateException, RemoteException {
        this.zzqs().zzqt();
    }

    public void zzf(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        this.zzqs().zza(d, this.zzafU, this.zzafV);
    }

    public void zzaf(boolean bl) throws IllegalStateException, RemoteException {
        this.zzqs().zza(bl, this.zzafU, this.zzafV);
    }

    public double zzqu() throws IllegalStateException {
        this.zzqy();
        return this.zzafU;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzqy();
        return this.zzafV;
    }

    public int zzqv() throws IllegalStateException {
        this.zzqy();
        return this.zzaii;
    }

    public int zzqw() throws IllegalStateException {
        this.zzqy();
        return this.zzaij;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzcE(string2);
        this.zzcD(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzaib;
            synchronized (map) {
                this.zzaib.put(string2, messageReceivedCallback);
            }
            this.zzqs().zzcI(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcD(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzaib;
        synchronized (map) {
            messageReceivedCallback = this.zzaib.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                this.zzqs().zzcJ(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzaeJ.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzqy();
        return this.zzahZ;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzqy();
        return this.zzaie;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzqx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzqx() {
        zzaeJ.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzaib;
        synchronized (map) {
            this.zzaib.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzahZ)) {
            this.zzahZ = applicationMetadata;
            this.zzaet.onApplicationMetadataChanged(this.zzahZ);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzqu();
        if (!Double.isNaN(d) && Math.abs(d - this.zzafU) > 1.0E-7) {
            this.zzafU = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzqD()) != this.zzafV) {
            this.zzafV = bl;
            bl2 = true;
        }
        zzaeJ.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzaig);
        if (this.zzaet != null && (bl2 || this.zzaig)) {
            this.zzaet.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzqv();
        if (n != this.zzaii) {
            this.zzaii = n;
            bl3 = true;
        }
        zzaeJ.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzaig);
        if (this.zzaet != null && (bl3 || this.zzaig)) {
            this.zzaet.onActiveInputStateChanged(this.zzaii);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzqw();
        if (n2 != this.zzaij) {
            this.zzaij = n2;
            bl4 = true;
        }
        zzaeJ.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzaig);
        if (this.zzaet != null && (bl4 || this.zzaig)) {
            this.zzaet.onStandbyStateChanged(this.zzaij);
        }
        this.zzaig = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzqn();
        if (!zzf.zza(string2, this.zzaie)) {
            this.zzaie = string2;
            bl = true;
        }
        zzaeJ.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzaif);
        if (this.zzaet != null && (bl || this.zzaif)) {
            this.zzaet.onApplicationStatusChanged();
        }
        this.zzaif = false;
    }

    void zzqy() throws IllegalStateException {
        if (!this.zzaih || this.zzaid == null || this.zzaid.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzaI(iBinder);
    }

    static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzaix;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzaix = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzqC() {
            zze zze2 = this.zzaix.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzqq();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzaix.get() == null;
        }

        @Override
        public void zzbr(int n) {
            zze zze2 = this.zzqC();
            if (zze2 == null) {
                return;
            }
            zzaeJ.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbZ(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzahZ = applicationMetadata;
            zze2.zzail = applicationMetadata.getApplicationId();
            zze2.zzaim = string3;
            zze2.zzaie = string2;
            Object object = zzais;
            synchronized (object) {
                if (zze2.zzaiq != null) {
                    zze2.zzaiq.setResult((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzaiq = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbs(int n) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzais;
            synchronized (object) {
                if (zze2.zzaiq != null) {
                    zze2.zzaiq.setResult((Object)new zza(new Status(n)));
                    zze2.zzaiq = null;
                }
            }
        }

        @Override
        public void zzbt(int n) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzbu(int n) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int n) {
            final zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzail = null;
            zze2.zzaim = null;
            this.zza(zze2, n);
            if (zze2.zzaet != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zze2.zzaet.onApplicationDisconnected(n);
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzaeJ.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zzaeJ.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zzaeJ.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzx(final String string2, final String string3) {
            final zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zzaeJ.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzaib;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzaib.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzaia, string2, string3);
                    } else {
                        zzaeJ.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            zzaeJ.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zze zze2 = this.zzaix.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zznt.zzb zzb2;
            Map map = zze2.zzaio;
            synchronized (map) {
                zzb2 = (zznt.zzb)zze2.zzaio.remove(l);
            }
            if (zzb2 != null) {
                zzb2.setResult((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzait;
            synchronized (object) {
                if (zze2.zzair != null) {
                    zze2.zzair.setResult((Object)new Status(n));
                    zze2.zzair = null;
                    return true;
                }
            }
            return false;
        }
    }

    static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzaaO;
        private final ApplicationMetadata zzaiu;
        private final String zzaiv;
        private final String zzPE;
        private final boolean zzaiw;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzaaO = status;
            this.zzaiu = applicationMetadata;
            this.zzaiv = string2;
            this.zzPE = string3;
            this.zzaiw = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzaiu;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzaiv;
        }

        @Override
        public String getSessionId() {
            return this.zzPE;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzaiw;
        }
    }
}

