/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zznt;

public class zzng
implements CastRemoteDisplayApi {
    private static final zzl zzaeJ = new zzl("CastRemoteDisplayApiImpl");
    private Api.zzf<zznh> zzajk;
    private VirtualDisplay zzajl;
    private final zznk zzajm = new zznk.zza(){

        @Override
        public void zzbw(int n) {
            zzaeJ.zzb("onRemoteDisplayEnded", new Object[0]);
            zzng.this.zzqL();
        }
    };

    public zzng(Api.zzf<zznh> zzf2) {
        this.zzajk = zzf2;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient googleApiClient, final String string2) {
        zzaeJ.zzb("startRemoteDisplay", new Object[0]);
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            @Override
            public void zza(zznh zznh2) throws RemoteException {
                zznh2.zza(new zzb.zza(zznh2), zzng.this.zzajm, string2);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient googleApiClient) {
        zzaeJ.zzb("stopRemoteDisplay", new Object[0]);
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            @Override
            public void zza(zznh zznh2) throws RemoteException {
                zznh2.zza(new zzb.zzb());
            }
        });
    }

    @TargetApi(value=19)
    private void zzqL() {
        if (this.zzajl != null) {
            Display display = this.zzajl.getDisplay();
            if (display != null) {
                int n = this.zzajl.getDisplay().getDisplayId();
                zzaeJ.zzb(new StringBuilder(38).append("releasing virtual display: ").append(n).toString(), new Object[0]);
            }
            this.zzajl.release();
            this.zzajl = null;
        }
    }

    abstract class com.google.android.gms.internal.zzng$zzb
    extends zznt.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zznh> {
        public com.google.android.gms.internal.zzng$zzb(GoogleApiClient googleApiClient) {
            super((Api.zzc)zzng.this.zzajk, googleApiClient);
        }

        public void zza(zznh zznh2) throws RemoteException {
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzs(Status status) {
            return new zzc(status);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzng$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzaeJ.zzb("onDisconnected", new Object[0]);
                zzng.this.zzqL();
                zzb.this.zzb(new zzc(Status.zzalw));
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzaeJ.zzb("onError: %d", n);
                zzng.this.zzqL();
                zzb.this.zzb(new zzc(Status.zzaly));
            }
        }

        @TargetApi(value=19)
        protected final class zza
        extends com.google.android.gms.internal.zzng$zza {
            private final zznh zzajo;

            public zza(zznh zznh2) {
                this.zzajo = zznh2;
            }

            private int zzl(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzaeJ.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzajo.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzaeJ.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                    return;
                }
                zzng.this.zzqL();
                int n3 = this.zzl(n, n2);
                zzng.this.zzajl = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzng.this.zzajl == null) {
                    zzaeJ.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                    return;
                }
                Display display = zzng.this.zzajl.getDisplay();
                if (display == null) {
                    zzaeJ.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                    return;
                }
                try {
                    this.zzajo.zza(this, zzng.this.zzajl.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzaeJ.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                }
            }

            @Override
            public void zzqN() {
                zzaeJ.zzb("onConnectedWithDisplay", new Object[0]);
                if (zzng.this.zzajl == null) {
                    zzaeJ.zzc("There is no virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                    return;
                }
                Display display = zzng.this.zzajl.getDisplay();
                if (display != null) {
                    zzb.this.zzb(new zzc(display));
                } else {
                    zzaeJ.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzaly));
                }
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzaeJ.zzb("onError: %d", n);
                zzng.this.zzqL();
                zzb.this.zzb(new zzc(Status.zzaly));
            }
        }
    }

    abstract class zza
    extends zzni.zza {
        zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int n) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzqN() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzaaO;
        private final Display zzId;

        public zzc(Display display) {
            this.zzaaO = Status.zzalw;
            this.zzId = display;
        }

        public zzc(Status status) {
            this.zzaaO = status;
            this.zzId = null;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzId;
        }
    }
}

