/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zznf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zzafy = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzafz = new zza().zzc("com.google.android.gms.cast.metadata.CREATION_DATE", "creationDateTime", 4).zzc("com.google.android.gms.cast.metadata.RELEASE_DATE", "releaseDate", 4).zzc("com.google.android.gms.cast.metadata.BROADCAST_DATE", "originalAirdate", 4).zzc("com.google.android.gms.cast.metadata.TITLE", "title", 1).zzc("com.google.android.gms.cast.metadata.SUBTITLE", "subtitle", 1).zzc("com.google.android.gms.cast.metadata.ARTIST", "artist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_ARTIST", "albumArtist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_TITLE", "albumName", 1).zzc("com.google.android.gms.cast.metadata.COMPOSER", "composer", 1).zzc("com.google.android.gms.cast.metadata.DISC_NUMBER", "discNumber", 2).zzc("com.google.android.gms.cast.metadata.TRACK_NUMBER", "trackNumber", 2).zzc("com.google.android.gms.cast.metadata.SEASON_NUMBER", "season", 2).zzc("com.google.android.gms.cast.metadata.EPISODE_NUMBER", "episode", 2).zzc("com.google.android.gms.cast.metadata.SERIES_TITLE", "seriesTitle", 1).zzc("com.google.android.gms.cast.metadata.STUDIO", "studio", 1).zzc("com.google.android.gms.cast.metadata.WIDTH", "width", 2).zzc("com.google.android.gms.cast.metadata.HEIGHT", "height", 2).zzc("com.google.android.gms.cast.metadata.LOCATION_NAME", "location", 1).zzc("com.google.android.gms.cast.metadata.LOCATION_LATITUDE", "latitude", 3).zzc("com.google.android.gms.cast.metadata.LOCATION_LONGITUDE", "longitude", 3);
    private final List<WebImage> zzAD = new ArrayList<WebImage>();
    private final Bundle zzafA = new Bundle();
    private int zzafB;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int n) {
        this.zzafB = n;
    }

    public int getMediaType() {
        return this.zzafB;
    }

    public void clear() {
        this.zzafA.clear();
        this.zzAD.clear();
    }

    public boolean containsKey(String string2) {
        return this.zzafA.containsKey(string2);
    }

    public Set<String> keySet() {
        return this.zzafA.keySet();
    }

    public void putString(String string2, String string3) {
        this.zzf(string2, 1);
        this.zzafA.putString(string2, string3);
    }

    public String getString(String string2) {
        this.zzf(string2, 1);
        return this.zzafA.getString(string2);
    }

    public void putInt(String string2, int n) {
        this.zzf(string2, 2);
        this.zzafA.putInt(string2, n);
    }

    public int getInt(String string2) {
        this.zzf(string2, 2);
        return this.zzafA.getInt(string2);
    }

    public void putDouble(String string2, double d) {
        this.zzf(string2, 3);
        this.zzafA.putDouble(string2, d);
    }

    public double getDouble(String string2) {
        this.zzf(string2, 3);
        return this.zzafA.getDouble(string2);
    }

    public void putDate(String string2, Calendar calendar) {
        this.zzf(string2, 4);
        this.zzafA.putString(string2, zznf.zza(calendar));
    }

    public Calendar getDate(String string2) {
        this.zzf(string2, 4);
        String string3 = this.zzafA.getString(string2);
        return string3 != null ? zznf.zzcL(string3) : null;
    }

    public String getDateAsString(String string2) {
        this.zzf(string2, 4);
        return this.zzafA.getString(string2);
    }

    private void zzf(String string2, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzafz.zzcz(string2);
        if (n2 != n && n2 != 0) {
            String string3 = String.valueOf(zzafy[n]);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Value for ").append(string2).append(" must be a ").append(string3).toString());
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zzafB);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zznf.zza(jSONObject, this.zzAD);
        switch (this.zzafB) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void zzi(JSONObject jSONObject) {
        this.clear();
        this.zzafB = 0;
        try {
            this.zzafB = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zznf.zza(this.zzAD, jSONObject);
        switch (this.zzafB) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zzb(jSONObject, new String[0]);
            }
        }
    }

    private void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string2 : stringArray) {
                if (!this.zzafA.containsKey(string2)) continue;
                int n = zzafz.zzcz(string2);
                switch (n) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzafz.zzcx(string2), (Object)this.zzafA.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzafz.zzcx(string2), this.zzafA.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzafz.zzcx(string2), this.zzafA.getDouble(string2));
                        continue block7;
                    }
                }
            }
            for (String string3 : this.zzafA.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.zzafA.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = zzafz.zzcy(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (zzafz.zzcz(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzafA.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = zznf.zzcL((String)object);
                                if (calendar == null) continue block10;
                                this.zzafA.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzafA.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzafA.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.zzafA.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzafA.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzafA.putDouble(string2, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)object;
        return this.zzb(this.zzafA, mediaMetadata.zzafA) && this.zzAD.equals(mediaMetadata.zzAD);
    }

    public int hashCode() {
        int n = 17;
        Set set = this.zzafA.keySet();
        for (String string2 : set) {
            n = 31 * n + this.zzafA.get(string2).hashCode();
        }
        n = 31 * n + this.zzAD.hashCode();
        return n;
    }

    public List<WebImage> getImages() {
        return this.zzAD;
    }

    public boolean hasImages() {
        return this.zzAD != null && !this.zzAD.isEmpty();
    }

    public void clearImages() {
        this.zzAD.clear();
    }

    public void addImage(WebImage webImage) {
        this.zzAD.add(webImage);
    }

    private boolean zzb(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string2 : set) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zzb((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static class zza {
        private final Map<String, String> zzafC = new HashMap<String, String>();
        private final Map<String, String> zzafD = new HashMap<String, String>();
        private final Map<String, Integer> zzafE = new HashMap<String, Integer>();

        public zza zzc(String string2, String string3, int n) {
            this.zzafC.put(string2, string3);
            this.zzafD.put(string3, string2);
            this.zzafE.put(string2, n);
            return this;
        }

        public String zzcx(String string2) {
            return this.zzafC.get(string2);
        }

        public String zzcy(String string2) {
            return this.zzafD.get(string2);
        }

        public int zzcz(String string2) {
            Integer n = this.zzafE.get(string2);
            return n != null ? n : 0;
        }
    }
}

