/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.clearcut;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.clearcut.zze;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.clearcut.zzaa;
import com.google.android.gms.internal.clearcut.zzge;
import com.google.android.gms.internal.clearcut.zzha;
import com.google.android.gms.internal.clearcut.zzj;
import com.google.android.gms.internal.clearcut.zzp;
import com.google.android.gms.internal.clearcut.zzr;
import com.google.android.gms.phenotype.ExperimentTokens;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.annotation.Nullable;

@KeepForSdk
public final class ClearcutLogger {
    private static final Api.ClientKey<zzj> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzj, Api.ApiOptions.NoOptions> CLIENT_BUILDER = new com.google.android.gms.clearcut.zza();
    @Deprecated
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("ClearcutLogger.API", CLIENT_BUILDER, CLIENT_KEY);
    private static final ExperimentTokens[] zze = new ExperimentTokens[0];
    private static final String[] zzf = new String[0];
    private static final byte[][] zzg = new byte[0][];
    private final Context zzh;
    private final String packageName;
    private final int zzi;
    private String zzj;
    private int zzk = -1;
    private String zzl;
    private String zzm;
    private final boolean zzn;
    private zzge.zzv.zzb zzo = zzge.zzv.zzb.zzbhk;
    private final com.google.android.gms.clearcut.zzb zzp;
    private final Clock zzq;
    private zzc zzr;
    private final zza zzs;

    @KeepForSdk
    public ClearcutLogger(Context context, String string, @Nullable String string2) {
        this(context, -1, string, string2, null, false, com.google.android.gms.internal.clearcut.zze.zzb(context), DefaultClock.getInstance(), null, new zzp(context));
    }

    @VisibleForTesting
    private ClearcutLogger(Context context, int n, String string, String string2, String string3, boolean bl, com.google.android.gms.clearcut.zzb zzb2, Clock clock, zzc zzc2, zza zza2) {
        this.zzh = context;
        this.packageName = context.getPackageName();
        this.zzi = ClearcutLogger.zza(context);
        this.zzk = -1;
        this.zzj = string;
        this.zzl = string2;
        this.zzm = null;
        this.zzn = bl;
        this.zzp = zzb2;
        this.zzq = clock;
        this.zzr = new zzc();
        this.zzo = zzge.zzv.zzb.zzbhk;
        this.zzs = zza2;
        if (bl) {
            Preconditions.checkArgument((string2 == null ? 1 : 0) != 0, (Object)"can't be anonymous with an upload account");
        }
    }

    @KeepForSdk
    public static ClearcutLogger anonymousLogger(Context context, String string) {
        return new ClearcutLogger(context, -1, string, null, null, true, com.google.android.gms.internal.clearcut.zze.zzb(context), DefaultClock.getInstance(), null, new zzp(context));
    }

    private static int zza(Context context) {
        int n = 0;
        try {
            n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"ClearcutLogger", (String)"This can't happen.", (Throwable)nameNotFoundException);
        }
        return n;
    }

    @KeepForSdk
    public final LogEventBuilder newEvent(@Nullable byte[] byArray) {
        return new LogEventBuilder(byArray, null);
    }

    private static int[] zza(ArrayList<Integer> arrayList) {
        if (arrayList == null) {
            return null;
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        ArrayList<Integer> arrayList2 = arrayList;
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            Integer n3 = arrayList2.get(i);
            int n4 = n3;
            nArray[n++] = n4;
        }
        return nArray;
    }

    public class LogEventBuilder {
        private int zzk;
        private String zzj;
        private String zzl;
        private String zzm;
        private zzge.zzv.zzb zzo;
        private final zzb zzt;
        private ArrayList<Integer> zzu;
        private ArrayList<String> zzv;
        private ArrayList<Integer> zzw;
        private ArrayList<ExperimentTokens> zzx;
        private ArrayList<byte[]> zzy;
        private boolean zzz;
        private final zzha zzaa;
        private boolean zzab;

        private LogEventBuilder(byte[] byArray) {
            this(byArray, (zzb)null);
        }

        private LogEventBuilder(byte[] byArray, zzb zzb2) {
            this.zzk = ClearcutLogger.this.zzk;
            this.zzj = ClearcutLogger.this.zzj;
            this.zzl = ClearcutLogger.this.zzl;
            ClearcutLogger clearcutLogger2 = ClearcutLogger.this;
            this.zzm = null;
            this.zzo = ClearcutLogger.this.zzo;
            this.zzu = null;
            this.zzv = null;
            this.zzw = null;
            this.zzx = null;
            this.zzy = null;
            this.zzz = true;
            this.zzaa = new zzha();
            this.zzab = false;
            this.zzl = ClearcutLogger.this.zzl;
            clearcutLogger2 = ClearcutLogger.this;
            this.zzm = null;
            this.zzaa.zzbkc = com.google.android.gms.internal.clearcut.zzaa.zze(ClearcutLogger.this.zzh);
            this.zzaa.zzbjf = ClearcutLogger.this.zzq.currentTimeMillis();
            this.zzaa.zzbjg = ClearcutLogger.this.zzq.elapsedRealtime();
            ClearcutLogger.this.zzr;
            long l = this.zzaa.zzbjf;
            this.zzaa.zzbju = TimeZone.getDefault().getOffset(l) / 1000;
            if (byArray != null) {
                this.zzaa.zzbjp = byArray;
            }
            this.zzt = null;
        }

        @KeepForSdk
        public LogEventBuilder setEventCode(int n) {
            this.zzaa.zzbji = n;
            return this;
        }

        @KeepForSdk
        public void log() {
            LogEventBuilder logEventBuilder = this;
            if (logEventBuilder.zzab) {
                throw new IllegalStateException("do not reuse LogEventBuilder");
            }
            logEventBuilder.zzab = true;
            LogEventBuilder logEventBuilder2 = logEventBuilder;
            zze zze2 = new zze(new zzr(logEventBuilder2.ClearcutLogger.this.packageName, logEventBuilder2.ClearcutLogger.this.zzi, logEventBuilder2.zzk, logEventBuilder2.zzj, logEventBuilder2.zzl, logEventBuilder2.zzm, logEventBuilder2.ClearcutLogger.this.zzn, logEventBuilder2.zzo), logEventBuilder2.zzaa, null, null, ClearcutLogger.zza(null), null, ClearcutLogger.zza(null), null, null, logEventBuilder2.zzz);
            if (logEventBuilder.ClearcutLogger.this.zzs.zza(zze2)) {
                logEventBuilder.ClearcutLogger.this.zzp.zzb(zze2);
                return;
            }
            PendingResults.immediatePendingResult((Status)Status.RESULT_SUCCESS, null);
        }

        /* synthetic */ LogEventBuilder(byte[] byArray, com.google.android.gms.clearcut.zza zza2) {
            this(byArray);
        }
    }

    public static final class zzc {
    }

    public static interface zza {
        public boolean zza(zze var1);
    }

    public static interface zzb {
        public byte[] zza();
    }
}

