/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.clearcut;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.internal.clearcut.zzac;
import com.google.android.gms.internal.clearcut.zzad;
import com.google.android.gms.internal.clearcut.zzae;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzab {
    private static final ConcurrentHashMap<Uri, zzab> zzde = new ConcurrentHashMap();
    private final ContentResolver zzdf;
    private final Uri uri;
    private final ContentObserver zzdg;
    private final Object zzdh = new Object();
    private volatile Map<String, String> zzdi;
    private final Object zzdj = new Object();
    @GuardedBy(value="listenersLock")
    private final List<zzad> zzdk = new ArrayList<zzad>();
    private static final String[] zzdl = new String[]{"key", "value"};

    private zzab(ContentResolver contentResolver, Uri uri) {
        this.zzdf = contentResolver;
        this.uri = uri;
        this.zzdg = new zzac(this, null);
    }

    public static zzab zza(ContentResolver contentResolver, Uri uri) {
        zzab zzab2 = zzde.get(uri);
        if (zzab2 == null) {
            zzab2 = new zzab(contentResolver, uri);
            zzab zzab3 = zzde.putIfAbsent(uri, zzab2);
            if (zzab3 == null) {
                zzab2.zzdf.registerContentObserver(zzab2.uri, false, zzab2.zzdg);
            } else {
                zzab2 = zzab3;
            }
        }
        return zzab2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zzg() {
        Map<String, String> map = zzae.zza("gms:phenotype:phenotype_flag:debug_disable_caching", false) ? this.zzi() : this.zzdi;
        if (map == null) {
            Object object = this.zzdh;
            synchronized (object) {
                map = this.zzdi;
                if (map == null) {
                    map = this.zzi();
                    this.zzdi = map;
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh() {
        Object object = this.zzdh;
        synchronized (object) {
            this.zzdi = null;
            return;
        }
    }

    private final Map<String, String> zzi() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Cursor cursor = this.zzdf.query(this.uri, zzdl, null, null, null);
            if (cursor != null) {
                try {
                    while (cursor.moveToNext()) {
                        hashMap.put(cursor.getString(0), cursor.getString(1));
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return hashMap;
        }
        catch (SQLiteException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzj() {
        Object object = this.zzdj;
        synchronized (object) {
            Iterator<zzad> iterator = this.zzdk.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzk();
            }
            return;
        }
    }

    static /* synthetic */ void zza(zzab zzab2) {
        zzab2.zzj();
    }
}

