/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzr {
    private final Context zza;
    @GuardedBy(value="this")
    private int zzb;
    @GuardedBy(value="this")
    private int zzc = 0;

    public zzr(Context context) {
        this.zza = context;
    }

    public final synchronized int zza() {
        List list;
        Intent intent;
        if (this.zzc != 0) {
            return this.zzc;
        }
        PackageManager packageManager = this.zza.getPackageManager();
        if (Wrappers.packageManager((Context)this.zza).checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"Metadata", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zzc = 1;
                return this.zzc;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zzc = 2;
            return this.zzc;
        }
        Log.w((String)"Metadata", (String)"Failed to resolve IID implementation package, falling back");
        this.zzc = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.zzc;
    }

    public final synchronized int zzb() {
        PackageInfo packageInfo;
        if (this.zzb == 0 && (packageInfo = this.zza("com.google.android.gms")) != null) {
            this.zzb = packageInfo.versionCode;
        }
        return this.zzb;
    }

    @Nullable
    private final PackageInfo zza(String string) {
        try {
            return Wrappers.packageManager((Context)this.zza).getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"Metadata", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

