/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.cloudmessaging.zza;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;

@SafeParcelable.Class(creator="CloudMessageCreator")
public final class CloudMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    @NonNull
    public static final Parcelable.Creator<CloudMessage> CREATOR = new zza();
    @NonNull
    @SafeParcelable.Field(id=1)
    final Intent zza;
    private Map zzb;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getOriginalPriority() {
        void var0_2;
        String string = this.zza.getStringExtra("google.original_priority");
        if (string == null) {
            String string2 = this.zza.getStringExtra("google.priority");
            return CloudMessage.zzb((String)var0_2);
        }
        String string3 = string;
        return CloudMessage.zzb((String)var0_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority() {
        void var0_2;
        String string = this.zza.getStringExtra("google.delivered_priority");
        if (string == null) {
            if (Objects.equals(this.zza.getStringExtra("google.priority_reduced"), "1")) {
                return 2;
            }
            String string2 = this.zza.getStringExtra("google.priority");
            return CloudMessage.zzb((String)var0_2);
        }
        String string3 = string;
        return CloudMessage.zzb((String)var0_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTtl() {
        void var0_3;
        Bundle bundle = this.zza.getExtras();
        if (bundle != null) {
            Object object = bundle.get("google.ttl");
        } else {
            Object var0_5 = null;
        }
        if (var0_3 instanceof Integer) {
            return (Integer)var0_3;
        }
        if (!(var0_3 instanceof String)) return 0;
        try {
            return Integer.parseInt((String)var0_3);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(String.valueOf(var0_3));
            String string2 = "Invalid TTL: ";
            Log.w((String)"CloudMessage", (String)string2.concat(string));
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSentTime() {
        void var0_3;
        Bundle bundle = this.zza.getExtras();
        if (bundle != null) {
            Object object = bundle.get("google.sent_time");
        } else {
            Object var0_4 = null;
        }
        if (var0_3 instanceof Long) {
            return (Long)var0_3;
        }
        if (!(var0_3 instanceof String)) return 0L;
        try {
            return Long.parseLong((String)var0_3);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(String.valueOf(var0_3));
            String string2 = "Invalid sent time: ";
            Log.w((String)"CloudMessage", (String)string2.concat(string));
            return 0L;
        }
    }

    @NonNull
    public Intent getIntent() {
        return this.zza;
    }

    @Nullable
    public String getCollapseKey() {
        return this.zza.getStringExtra("collapse_key");
    }

    @Nullable
    public String getFrom() {
        return this.zza.getStringExtra("from");
    }

    @Nullable
    public String getMessageId() {
        String string = this.zza.getStringExtra("google.message_id");
        if (string == null) {
            return this.zza.getStringExtra("message_id");
        }
        return string;
    }

    @Nullable
    public String getMessageType() {
        return this.zza.getStringExtra("message_type");
    }

    @Nullable
    public String getSenderId() {
        return this.zza.getStringExtra("google.c.sender.id");
    }

    @Nullable
    public String getTo() {
        return this.zza.getStringExtra("google.to");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public synchronized Map<String, String> getData() {
        if (this.zzb == null) {
            Bundle bundle = this.zza.getExtras();
            ArrayMap arrayMap = new ArrayMap();
            if (bundle != null) {
                for (String string : bundle.keySet()) {
                    Object object = bundle.get(string);
                    if (!(object instanceof String)) continue;
                    object = (String)object;
                    if (string.startsWith("google.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                    arrayMap.put((Object)string, object);
                }
            }
            this.zzb = arrayMap;
        }
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @SafeParcelable.Constructor
    public CloudMessage(@NonNull @SafeParcelable.Param(id=1) Intent intent) {
        void var1_1;
        this.zza = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v0, (int)1, (Parcelable)this.zza, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v0, (int)SafeParcelWriter.beginObjectHeader((Parcel)out));
    }

    @Nullable
    public byte[] getRawData() {
        return this.zza.getByteArrayExtra("rawData");
    }

    private static int zzb(@Nullable String string) {
        if (Objects.equals(string, "high")) {
            return 1;
        }
        if (Objects.equals(string, "normal")) {
            return 2;
        }
        return 0;
    }

    @Nullable
    final Integer zza() {
        if (this.zza.hasExtra("google.product_id")) {
            return this.zza.getIntExtra("google.product_id", 0);
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface MessagePriority {
    }
}

