/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.zzg;
import com.google.android.gms.cloudmessaging.zzh;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.internal.cloudmessaging.zze;
import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class CloudMessagingReceiver
extends BroadcastReceiver {
    @Nullable
    private static SoftReference zza;
    @Nullable
    private static SoftReference zzb;

    @WorkerThread
    protected abstract int onMessageReceive(@NonNull Context var1, @NonNull CloudMessage var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    protected Executor getBroadcastExecutor() {
        Class<CloudMessagingReceiver> clazz = CloudMessagingReceiver.class;
        synchronized (clazz) {
            Object object = zza;
            object = object != null ? (ExecutorService)((SoftReference)object).get() : null;
            if (object != null) return object;
            zze.zza();
            object = new NamedThreadFactory("firebase-iid-executor");
            object = Executors.unconfigurableExecutorService(Executors.newCachedThreadPool((ThreadFactory)object));
            zza = new SoftReference<Object>(object);
            return object;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    protected void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
    }

    /*
     * WARNING - void declaration
     */
    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        void var1_1;
        void var2_2;
        if (intent == null) {
            return;
        }
        boolean bl = this.isOrderedBroadcast();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getBroadcastExecutor().execute(new zzh(this, (Intent)var2_2, (Context)var1_1, bl, pendingResult));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final int zzb(@NonNull Context context, @NonNull Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"CloudMessagingReceiver", (String)"Notification pending intent canceled");
            }
        }
        if ((pendingIntent = intent.getExtras()) != null) {
            pendingIntent.remove("pending_intent");
        } else {
            pendingIntent = new Bundle();
        }
        if (Objects.equals(intent.getAction(), "com.google.firebase.messaging.NOTIFICATION_DISMISS")) {
            this.onNotificationDismissed(context, (Bundle)pendingIntent);
            return -1;
        }
        Log.e((String)"CloudMessagingReceiver", (String)"Unknown notification action");
        return 500;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zza(Intent object, Context context, boolean bl, BroadcastReceiver.PendingResult pendingResult) {
        int n;
        block17: {
            CountDownLatch countDownLatch;
            Object object2;
            try {
                object2 = object.getParcelableExtra("wrapped_intent");
                boolean bl2 = object2 instanceof Intent;
                object2 = bl2 ? (Intent)object2 : null;
                if (object2 != null) {
                    n = this.zzb(context, (Intent)object2);
                    break block17;
                }
                object2 = object.getExtras();
                if (object2 == null) {
                    n = 500;
                    break block17;
                }
                object2 = new CloudMessage((Intent)object);
                countDownLatch = new CountDownLatch(1);
                Class<CloudMessagingReceiver> clazz = CloudMessagingReceiver.class;
                synchronized (clazz) {
                    object = zzb;
                    object = object != null ? (Executor)((SoftReference)object).get() : null;
                }
            }
            catch (Throwable throwable) {
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                throw throwable;
            }
            {
                if (object == null) {
                    zze.zza();
                    object = new NamedThreadFactory("pscm-ack-executor");
                    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)object);
                    threadPoolExecutor.allowCoreThreadTimeOut(true);
                    object = Executors.unconfigurableExecutorService(threadPoolExecutor);
                    zzb = new SoftReference<Object>(object);
                }
            }
            object.execute(new zzg(context, (CloudMessage)((Object)object2), countDownLatch));
            n = this.onMessageReceive(context, (CloudMessage)((Object)object2));
            long l = TimeUnit.SECONDS.toMillis(1L);
            boolean bl3 = countDownLatch.await(l, TimeUnit.MILLISECONDS);
            if (!bl3) {
                Log.w((String)"CloudMessagingReceiver", (String)"Message ack timed out");
            }
            break block17;
            catch (InterruptedException interruptedException) {
                String string = ((Object)interruptedException).toString();
                Log.w((String)"CloudMessagingReceiver", (String)"Message ack failed: ".concat(string));
            }
        }
        if (bl && pendingResult != null) {
            pendingResult.setResultCode(n);
        }
        if (pendingResult != null) {
            pendingResult.finish();
            return;
        }
    }

    public static final class IntentKeys {
        @NonNull
        public static final String PENDING_INTENT = "pending_intent";
        @NonNull
        public static final String WRAPPED_INTENT = "wrapped_intent";

        private IntentKeys() {
        }
    }

    public static final class IntentActionKeys {
        @NonNull
        public static final String NOTIFICATION_OPEN = "com.google.firebase.messaging.NOTIFICATION_OPEN";
        @NonNull
        public static final String NOTIFICATION_DISMISS = "com.google.firebase.messaging.NOTIFICATION_DISMISS";

        private IntentActionKeys() {
        }
    }
}

