/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.awareness.snapshot.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.awareness.snapshot.internal.zzn;
import com.google.android.gms.awareness.state.Weather;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzbu;

public class WeatherImpl
extends AbstractSafeParcelable
implements Weather {
    public static final Parcelable.Creator<WeatherImpl> CREATOR = new zzn();
    private final int mVersionCode;
    private final float gn;
    private final float go;
    private final float gp;
    private final int gq;
    private final int[] gr;

    WeatherImpl(int n, float f, float f2, float f3, int n2, int[] nArray) {
        this.mVersionCode = n;
        this.gn = f;
        this.go = f2;
        this.gp = f3;
        this.gq = n2;
        this.gr = nArray;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public float zzahj() {
        return this.gp;
    }

    public float zzahk() {
        return this.go;
    }

    public float zzahl() {
        return this.gn;
    }

    @Override
    public float getDewPoint(int n) {
        return WeatherImpl.zza(n, this.gp);
    }

    @Override
    public float getFeelsLikeTemperature(int n) {
        return WeatherImpl.zza(n, this.go);
    }

    @Override
    public float getTemperature(int n) {
        return WeatherImpl.zza(n, this.gn);
    }

    @Override
    public int getHumidity() {
        return this.gq;
    }

    @Override
    public int[] getConditions() {
        return this.gr;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temp=").append(this.getTemperature(1)).append("F/").append(this.getTemperature(2)).append("C, Feels=").append(this.getFeelsLikeTemperature(1)).append("F/").append(this.getFeelsLikeTemperature(2)).append("C, Dew=").append(this.getDewPoint(1)).append("F/").append(this.getDewPoint(2)).append("C, Humidity=").append(this.getHumidity()).append(", Condition=");
        if (this.getConditions() == null) {
            stringBuilder.append("unknown");
        } else {
            stringBuilder.append("[");
            boolean bl = true;
            for (int n : this.getConditions()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append(n);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    static float zza(int n, float f) {
        switch (n) {
            case 1: {
                return f;
            }
            case 2: {
                return WeatherImpl.zzc(f);
            }
        }
        zzbu.zza("WeatherImpl", "Invalid temperature unit %s", (Object)n);
        throw new IllegalArgumentException("Invalid temperature unit");
    }

    private static float zzc(float f) {
        return 5.0f * (f - 32.0f) / 9.0f;
    }
}

