/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzl;
import com.google.android.gms.internal.zzago;
import com.google.android.gms.internal.zzagq;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzahp;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzajw;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzzv;
import java.io.InputStream;
import java.io.OutputStream;

public class zzahl
implements DriveContents {
    private final zzc zzaLH;
    private boolean mClosed = false;
    private boolean zzaLI = false;
    private boolean zzaLJ = false;

    public zzahl(zzc zzc2) {
        this.zzaLH = (zzc)((Object)zzac.zzw((Object)((Object)zzc2)));
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaLH.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzaLH.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzzD()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaLH.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzzD()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaLH.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaLI) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaLI = true;
        return this.zzaLH.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzzD()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaLH.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaLJ) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaLJ = true;
        return this.zzaLH.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.zzzD()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaLH.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzzC();
        return googleApiClient.zza((zzzv.zza)new zzahi.zzc(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzajw(zzahl.this.getDriveId(), 0x20000000, zzahl.this.zzaLH.getRequestId()), (zzail)new zzajy((zzzv.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzl.zzb(executionOptions));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzl zzl2) {
        if (zzl2 == null) {
            zzl2 = (zzl)new zzl.zza().build();
        }
        if (this.zzaLH.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzdX(zzl2.zzzH()) && !this.zzaLH.zzzz()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzl2.zzh(googleApiClient);
        if (this.zzzD()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzaJN;
        final zzl zzl3 = zzl2;
        this.zzzC();
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                metadataChangeSet2.zzzP().setContext(zzahk2.getContext());
                zzahk2.zzAi().zza(new zzago(zzahl.this.zzaLH.getDriveId(), metadataChangeSet2.zzzP(), zzahl.this.zzaLH.getRequestId(), zzahl.this.zzaLH.zzzz(), zzl3), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient googleApiClient) {
        if (this.zzzD()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzzC();
        (googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzagq(zzahl.this.zzaLH.getRequestId(), false), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(this){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzahp.zzF("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzahp.zzD("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public zzc zzzB() {
        return this.zzaLH;
    }

    @Override
    public void zzzC() {
        zzo.zza((ParcelFileDescriptor)this.zzaLH.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzzD() {
        return this.mClosed;
    }
}

