/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.internal.zzagh;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaio;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzzv;
import java.util.ArrayList;
import java.util.Set;

public class zzahr
implements DriveResource {
    protected final DriveId zzaJj;

    public zzahr(DriveId driveId) {
        this.zzaJj = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaJj;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient googleApiClient) {
        return this.zza(googleApiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zzzv.zza)new zzd(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzaie(zzahr.this.zzaJj, bl), (zzail)new zzb((zzzv.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzzv.zza)new zzahi.zzh(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzaio(zzahr.this.zzaJj), (zzail)new zza((zzzv.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient googleApiClient, Set<DriveId> set) {
        if (set == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(set);
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzakn(zzahr.this.zzaJj, arrayList), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return googleApiClient.zzb((zzzv.zza)new zzd(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                metadataChangeSet.zzzP().setContext(zzahk2.getContext());
                zzahk2.zzAi().zza(new zzala(zzahr.this.zzaJj, metadataChangeSet.zzzP()), (zzail)new zzb((zzzv.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzahe(zzahr.this.zzaJj), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        return zzahk2.zza(googleApiClient, this.zzaJj, changeListener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient googleApiClient, ChangeListener changeListener) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        return zzahk2.zzb(googleApiClient, this.zzaJj, changeListener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient googleApiClient) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        return zzahk2.zza(googleApiClient, this.zzaJj);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient googleApiClient) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        return zzahk2.zzb(googleApiClient, this.zzaJj);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzaku(zzahr.this.zzaJj), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zzahj.zza(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                zzahk2.zzAi().zza(new zzaky(zzahr.this.zzaJj), (zzail)new zzakp((zzzv.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends zzagh {
        private final zzzv.zzb<DriveApi.MetadataBufferResult> zzaFq;

        public zza(zzzv.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzaji zzaji2) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(zzaji2.zzAw());
            this.zzaFq.setResult((Object)new zzahi.zzg(Status.zzayh, metadataBuffer, false));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zzahi.zzg(status, null, false));
        }
    }

    private static class zzb
    extends zzagh {
        private final zzzv.zzb<DriveResource.MetadataResult> zzaFq;

        public zzb(zzzv.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzajl zzajl2) throws RemoteException {
            this.zzaFq.setResult((Object)new zzc(Status.zzayh, new zzahd(zzajl2.zzAx())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzahq;
        private final Metadata zzaMg;

        public zzc(Status status, Metadata metadata) {
            this.zzahq = status;
            this.zzaMg = metadata;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzaMg;
        }
    }

    private abstract class zzd
    extends zzahj<DriveResource.MetadataResult> {
        private zzd(zzahr zzahr2, GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzS(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzS(status);
        }
    }
}

