/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahp;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzalg;
import com.google.android.gms.internal.zzbus;
import com.google.android.gms.internal.zzbut;

public class DriveId
extends zza
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzh();
    final int mVersionCode;
    final String zzaJv;
    final long zzaJw;
    final long zzaJe;
    final int zzaJx;
    private volatile String zzaJg = null;
    private volatile String zzaJy = null;

    public static DriveId zzdH(String string) {
        zzac.zzw((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaJv;
    }

    public int getResourceType() {
        return this.zzaJx;
    }

    public DriveFile asDriveFile() {
        if (this.zzaJx == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzahm(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaJx == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzaho(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaJx == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaJx == 0) {
            return this.asDriveFile();
        }
        return new zzahr(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    DriveId(int n, String string, long l, long l2, int n2) {
        this.mVersionCode = n;
        this.zzaJv = string;
        zzac.zzas((!"".equals(string) ? 1 : 0) != 0);
        zzac.zzas((string != null || l != -1L ? 1 : 0) != 0);
        this.zzaJw = l;
        this.zzaJe = l2;
        this.zzaJx = n2;
    }

    public DriveId(String string, long l, long l2, int n) {
        this(1, string, l, l2, n);
    }

    public int hashCode() {
        if (this.zzaJw == -1L) {
            return this.zzaJv.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzaJe));
        String string2 = String.valueOf(String.valueOf(this.zzaJw));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzaJe != this.zzaJe) {
            return false;
        }
        if (driveId.zzaJw == -1L && this.zzaJw == -1L) {
            return driveId.zzaJv.equals(this.zzaJv);
        }
        if (this.zzaJv == null || driveId.zzaJv == null) {
            return driveId.zzaJw == this.zzaJw;
        }
        if (driveId.zzaJw == this.zzaJw) {
            if (driveId.zzaJv.equals(this.zzaJv)) {
                return true;
            }
            zzahp.zzE("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaJg == null) {
            byte[] byArray = this.zzzy();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzaJg = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzaJg;
    }

    public final String toInvariantString() {
        if (this.zzaJy == null) {
            byte[] byArray = this.zzzE();
            this.zzaJy = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaJy;
    }

    final byte[] zzzy() {
        zzalf zzalf2 = new zzalf();
        zzalf2.versionCode = this.mVersionCode;
        zzalf2.zzaNi = this.zzaJv == null ? "" : this.zzaJv;
        zzalf2.zzaNj = this.zzaJw;
        zzalf2.zzaNg = this.zzaJe;
        zzalf2.zzaNk = this.zzaJx;
        byte[] byArray = zzbut.zzf((zzbut)zzalf2);
        return byArray;
    }

    private byte[] zzzE() {
        zzalg zzalg2 = new zzalg();
        zzalg2.zzaNj = this.zzaJw;
        zzalg2.zzaNg = this.zzaJe;
        byte[] byArray = zzbut.zzf((zzbut)zzalg2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzac.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        String string3 = string.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string3, (int)10);
        return DriveId.zzt(byArray);
    }

    static DriveId zzt(byte[] byArray) {
        zzalf zzalf2;
        try {
            zzalf2 = zzalf.zzu(byArray);
        }
        catch (zzbus zzbus2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzalf2.zzaNi) ? null : zzalf2.zzaNi;
        DriveId driveId = new DriveId(zzalf2.versionCode, string, zzalf2.zzaNj, zzalf2.zzaNg, zzalf2.zzaNk);
        return driveId;
    }
}

