/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzahk;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaJF;
    private final boolean zzaJG;
    private final int zzaJH;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzaJF = string;
        this.zzaJG = bl;
        this.zzaJH = n;
    }

    public String zzzF() {
        return this.zzaJF;
    }

    public boolean zzzG() {
        return this.zzaJG;
    }

    public int zzzH() {
        return this.zzaJH;
    }

    public static boolean zzdX(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzdY(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzdI(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() <= 65536;
    }

    public void zzh(GoogleApiClient googleApiClient) {
        zzahk zzahk2 = (zzahk)googleApiClient.zza(Drive.zzahc);
        if (this.zzzG() && !zzahk2.zzAm()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzaa.equal((Object)this.zzaJF, (Object)executionOptions.zzaJF) && this.zzaJH == executionOptions.zzaJH && this.zzaJG == executionOptions.zzaJG;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaJF, this.zzaJH, this.zzaJG});
    }

    public static class Builder {
        protected String zzaJF;
        protected boolean zzaJG;
        protected int zzaJH = 0;

        public Builder setTrackingTag(String string) {
            if (!ExecutionOptions.zzdI(string)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaJF = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzaJG = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            if (!ExecutionOptions.zzdY(n)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzaJH = n;
            return this;
        }

        protected void zzzI() {
            if (this.zzaJH == 1 && !this.zzaJG) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzzI();
            return new ExecutionOptions(this.zzaJF, this.zzaJG, this.zzaJH);
        }
    }
}

