/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzalj;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzaJN = new MetadataChangeSet(MetadataBundle.zzAI());
    private final MetadataBundle zzaJO;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzaJO = metadataBundle.zzAJ();
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzaJO.zza(zzalh.zzaNC);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzAD();
    }

    public String getDescription() {
        return this.zzaJO.zza(zzalh.zzaND);
    }

    public String getIndexableText() {
        return this.zzaJO.zza(zzalh.zzaNJ);
    }

    public Date getLastViewedByMeDate() {
        return this.zzaJO.zza(zzalj.zzaOt);
    }

    public String getMimeType() {
        return this.zzaJO.zza(zzalh.zzaNX);
    }

    public String getTitle() {
        return this.zzaJO.zza(zzalh.zzaOg);
    }

    public Boolean isPinned() {
        return this.zzaJO.zza(zzalh.zzaNP);
    }

    public Boolean isStarred() {
        return this.zzaJO.zza(zzalh.zzaOe);
    }

    public Boolean isViewed() {
        return this.zzaJO.zza(zzalh.zzaNW);
    }

    public MetadataBundle zzzP() {
        return this.zzaJO;
    }

    public MetadataChangeSet zzzQ() {
        return new MetadataChangeSet(this.zzzP());
    }

    public <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this.zzzQ();
        metadataChangeSet.zzzP().zzc(metadataField, t);
        return metadataChangeSet;
    }

    public static class Builder {
        private final MetadataBundle zzaJO = MetadataBundle.zzAI();
        private AppVisibleCustomProperties.zza zzaJP;

        private AppVisibleCustomProperties.zza zzzR() {
            if (this.zzaJP == null) {
                this.zzaJP = new AppVisibleCustomProperties.zza();
            }
            return this.zzaJP;
        }

        private int zzdL(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzac.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzac.zzb((Object)string, (Object)"value");
            int n = this.zzdL(customPropertyKey.getKey()) + this.zzdL(string);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzzR().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzzR().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzaJO.zzc(zzalh.zzaND, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = this.zzdL(string);
            this.zzk("Indexable text size", 131072, n);
            this.zzaJO.zzc(zzalh.zzaNJ, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzaJO.zzc(zzalj.zzaOt, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzaJO.zzc(zzalh.zzaNX, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzaJO.zzc(zzalh.zzaNP, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzaJO.zzc(zzalh.zzaOe, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzaJO.zzc(zzalh.zzaOg, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzaJO.zzc(zzalh.zzaNW, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzaJP != null) {
                this.zzaJO.zzc(zzalh.zzaNC, this.zzaJP.zzAE());
            }
            return new MetadataChangeSet(this.zzaJO);
        }
    }
}

