/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.zzk;
import com.google.android.gms.internal.zzagh;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzahb;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzzv;

public class zzaho
extends zzahr
implements DriveFolder {
    public zzaho(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        return new zzahi().query(googleApiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, zzk.zza(executionOptions));
    }

    private void zzb(MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzj zzj2 = zzj.zzdO(metadataChangeSet.getMimeType());
        if (zzj2 != null && !zzj2.zzAL()) {
            throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
        }
    }

    public PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzk zzk2) {
        if (zzk2 == null) {
            zzk2 = (zzk)new zzk.zza().build();
        }
        this.zzb(googleApiClient, metadataChangeSet, driveContents, zzk2);
        zzj zzj2 = zzj.zzdO(metadataChangeSet.getMimeType());
        int n = this.zza(driveContents, zzj2);
        String string = zzk2.zzzK();
        if (string != null) {
            metadataChangeSet = this.zza(metadataChangeSet, string);
        }
        return this.zza(googleApiClient, metadataChangeSet, n, zzk2);
    }

    private MetadataChangeSet zza(MetadataChangeSet metadataChangeSet, String string) {
        return metadataChangeSet.zza(zzalh.zzaOk, string);
    }

    private int zza(DriveContents driveContents, zzj zzj2) {
        int n;
        if (driveContents == null) {
            n = zzj2 != null && zzj2.zzAM() ? 0 : 1;
        } else {
            n = driveContents.zzzB().getRequestId();
            driveContents.zzzC();
        }
        return n;
    }

    private void zzb(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzk zzk2) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzj zzj2 = zzj.zzdO(metadataChangeSet.getMimeType());
        if (zzj2 != null && zzj2.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        zzk2.zzh(googleApiClient);
        if (driveContents == null) {
            return;
        }
        if (!(driveContents instanceof zzahl)) {
            throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
        }
        if (driveContents.getDriveId() != null) {
            throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
        }
        if (driveContents.zzzD()) {
            throw new IllegalArgumentException("DriveContents are already closed.");
        }
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final zzk zzk2) {
        zzj zzj2 = zzj.zzdO(metadataChangeSet.getMimeType());
        final int n2 = zzj2 != null && zzj2.zzAM() ? 1 : 0;
        return googleApiClient.zzb((zzzv.zza)new zzd(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                metadataChangeSet.zzzP().setContext(zzahk2.getContext());
                zzagz zzagz2 = new zzagz(zzaho.this.getDriveId(), metadataChangeSet.zzzP(), n, n2, zzk2);
                zzahk2.zzAi().zza(zzagz2, (zzail)new zza((zzzv.zzb<DriveFolder.DriveFileResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return googleApiClient.zzb((zzzv.zza)new zzf(googleApiClient){

            protected void zza(zzahk zzahk2) throws RemoteException {
                metadataChangeSet.zzzP().setContext(zzahk2.getContext());
                zzahk2.zzAi().zza(new zzahb(zzaho.this.getDriveId(), metadataChangeSet.zzzP()), (zzail)new zzb((zzzv.zzb<DriveFolder.DriveFolderResult>)this));
            }
        });
    }

    private static class zzb
    extends zzagh {
        private final zzzv.zzb<DriveFolder.DriveFolderResult> zzaFq;

        public zzb(zzzv.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzaja zzaja2) throws RemoteException {
            this.zzaFq.setResult((Object)new zze(Status.zzayh, new zzaho(zzaja2.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status zzahq;
        private final DriveFolder zzaLY;

        public zze(Status status, DriveFolder driveFolder) {
            this.zzahq = status;
            this.zzaLY = driveFolder;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.zzaLY;
        }
    }

    static abstract class zzf
    extends zzahj<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzQ(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzQ(status);
        }
    }

    private static class zza
    extends zzagh {
        private final zzzv.zzb<DriveFolder.DriveFileResult> zzaFq;

        public zza(zzzv.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zza(zzaja zzaja2) throws RemoteException {
            this.zzaFq.setResult((Object)new zzc(Status.zzayh, new zzahm(zzaja2.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaFq.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status zzahq;
        private final DriveFile zzaLX;

        public zzc(Status status, DriveFile driveFile) {
            this.zzahq = status;
            this.zzaLX = driveFile;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.zzaLX;
        }
    }

    static abstract class zzd
    extends zzahj<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzP(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzP(status);
        }
    }
}

