/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzahx;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaLc;
    private final boolean zzaLd;
    private final int zzaLe;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzaLc = string;
        this.zzaLd = bl;
        this.zzaLe = n;
    }

    public String zzAt() {
        return this.zzaLc;
    }

    public boolean zzAu() {
        return this.zzaLd;
    }

    public int zzAv() {
        return this.zzaLe;
    }

    public static boolean zzeg(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzeh(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzdE(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() <= 65536;
    }

    public void zzh(GoogleApiClient googleApiClient) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        if (this.zzAu() && !zzahx2.zzBa()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzaa.equal((Object)this.zzaLc, (Object)executionOptions.zzaLc) && this.zzaLe == executionOptions.zzaLe && this.zzaLd == executionOptions.zzaLd;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaLc, this.zzaLe, this.zzaLd});
    }

    public static class Builder {
        protected String zzaLc;
        protected boolean zzaLd;
        protected int zzaLe = 0;

        public Builder setTrackingTag(String string) {
            if (!ExecutionOptions.zzdE(string)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaLc = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzaLd = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            if (!ExecutionOptions.zzeh(n)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzaLe = n;
            return this;
        }

        protected void zzAw() {
            if (this.zzaLe == 1 && !this.zzaLd) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzAw();
            return new ExecutionOptions(this.zzaLc, this.zzaLd, this.zzaLe);
        }
    }
}

