/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zzf;
import com.google.android.gms.drive.metadata.internal.zzi;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzalu;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzi();
    final int zzaiI;
    final Bundle zzaOT;

    MetadataBundle(int n, Bundle bundle) {
        this.zzaiI = n;
        this.zzaOT = (Bundle)zzac.zzw((Object)bundle);
        this.zzaOT.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzaOT.keySet()) {
            if (zzf.zzdJ(string) != null) continue;
            arrayList.add(string);
            String string2 = String.valueOf(string);
            zzaic.zzF("MetadataBundle", string2.length() != 0 ? "Ignored unknown metadata field in bundle: ".concat(string2) : new String("Ignored unknown metadata field in bundle: "));
        }
        for (String string : arrayList) {
            this.zzaOT.remove(string);
        }
    }

    private MetadataBundle(Bundle bundle) {
        this(1, bundle);
    }

    public static MetadataBundle zzBw() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzBw();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public MetadataBundle zzBx() {
        return new MetadataBundle(new Bundle(this.zzaOT));
    }

    public <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zzf.zzdJ(metadataField.getName()) == null) {
            String string = String.valueOf(metadataField.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.zzaOT);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzs(this.zzaOT);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzaOT.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzBy() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzaOT.keySet()) {
            hashSet.add(zzf.zzdJ(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzalu.zzaPC);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 1;
        for (String string : this.zzaOT.keySet()) {
            n = n * 31 + this.zzaOT.get(string).hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.zzaOT.keySet();
        if (!set.equals(metadataBundle.zzaOT.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzaa.equal((Object)this.zzaOT.get(string), (Object)metadataBundle.zzaOT.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.zzaOT);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }
}

