/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzahz;
import com.google.android.gms.internal.zzaib;
import com.google.android.gms.internal.zzair;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzajn;
import com.google.android.gms.internal.zzajt;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzalc;
import java.util.List;

public class zzahv
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient googleApiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return googleApiClient.zza((zzaad.zza)new zzh(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzakq(query), (zzaiy)new zzi((zzaad.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient googleApiClient) {
        return this.zzb(googleApiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zzb(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzahh(n), (zzaiy)new zza((zzaad.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zza((zzaad.zza)new zzf(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzair(DriveId.zzdD(string), false), (zzaiy)new zzd((zzaad.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzahz(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzaib(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient googleApiClient) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        if (!zzahx2.zzAZ()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzahx2.zzAX();
        return driveId != null ? new zzaib(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient googleApiClient) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        if (!zzahx2.zzAZ()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzahx2.zzAY();
        return driveId != null ? new zzaib(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzaad.zza)new zzahw<BooleanResult>(this, googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                final 5 var2_2 = this;
                zzahx2.zzAW().zze(new zzagu(this){

                    @Override
                    public void zzaA(boolean bl) {
                        var2_2.zzb((Result)new BooleanResult(Status.zzazx, bl));
                    }
                });
            }

            protected BooleanResult zzM(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzM(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, List<String> list) {
        zzahx zzahx2 = (zzahx)googleApiClient.zza(Drive.zzaid);
        return zzahx2.cancelPendingActions(googleApiClient, list);
    }

    private static class zzi
    extends zzagu {
        private final zzaad.zzb<DriveApi.MetadataBufferResult> zzaGN;

        public zzi(zzaad.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajt zzajt2) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(zzajt2.zzBi());
            this.zzaGN.setResult((Object)new zzg(Status.zzazx, metadataBuffer, zzajt2.zzBj()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status zzair;
        private final MetadataBuffer zzaMM;
        private final boolean zzaMN;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzair = status;
            this.zzaMM = metadataBuffer;
            this.zzaMN = bl;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaMM;
        }

        public void release() {
            if (this.zzaMM != null) {
                this.zzaMM.release();
            }
        }
    }

    static abstract class zzh
    extends zzahw<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzP(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzP(status);
        }
    }

    static class zzd
    extends zzagu {
        private final zzaad.zzb<DriveApi.DriveIdResult> zzaGN;

        public zzd(zzaad.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajy zzajy2) throws RemoteException {
            this.zzaGN.setResult((Object)new zze(Status.zzazx, new zzahq(zzajy2.zzBl()).getDriveId()));
        }

        @Override
        public void zza(zzajn zzajn2) throws RemoteException {
            this.zzaGN.setResult((Object)new zze(Status.zzazx, zzajn2.getDriveId()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status zzair;
        private final DriveId zzaKG;

        public zze(Status status, DriveId driveId) {
            this.zzair = status;
            this.zzaKG = driveId;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzaKG;
        }
    }

    static abstract class zzf
    extends zzahw<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzO(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzO(status);
        }
    }

    private static class zza
    extends zzagu {
        private final zzaad.zzb<DriveApi.DriveContentsResult> zzaGN;

        public zza(zzaad.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajh zzajh2) throws RemoteException {
            this.zzaGN.setResult((Object)new zzb(Status.zzazx, new zzahy(zzajh2.zzBc())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzair;
        private final DriveContents zzaKJ;

        public zzb(Status status, DriveContents driveContents) {
            this.zzair = status;
            this.zzaKJ = driveContents;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzaKJ;
        }

        public void release() {
            if (this.zzaKJ != null) {
                this.zzaKJ.zzAq();
            }
        }
    }

    static abstract class zzc
    extends zzahw<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzN(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzN(status);
        }
    }

    @SuppressLint(value={"MissingRemoteException"})
    static class zzj
    extends zzahw.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzb((Result)status);
        }
    }
}

