/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzl;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzahb;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzalc;
import java.io.InputStream;
import java.io.OutputStream;

public class zzahy
implements DriveContents {
    private final zzc zzaNe;
    private boolean mClosed = false;
    private boolean zzaNf = false;
    private boolean zzaNg = false;

    public zzahy(zzc zzc2) {
        this.zzaNe = (zzc)((Object)zzac.zzw((Object)((Object)zzc2)));
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaNe.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzaNe.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzAr()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaNe.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzAr()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaNe.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaNf) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaNf = true;
        return this.zzaNe.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzAr()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaNe.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaNg) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaNg = true;
        return this.zzaNe.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.zzAr()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaNe.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzAq();
        return googleApiClient.zza((zzaad.zza)new zzahv.zzc(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzakj(zzahy.this.getDriveId(), 0x20000000, zzahy.this.zzaNe.getRequestId()), (zzaiy)new zzakl((zzaad.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzl.zzb(executionOptions));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzl zzl2) {
        if (zzl2 == null) {
            zzl2 = (zzl)new zzl.zza().build();
        }
        if (this.zzaNe.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzeg(zzl2.zzAv()) && !this.zzaNe.zzAn()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzl2.zzh(googleApiClient);
        if (this.zzAr()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzaLk;
        final zzl zzl3 = zzl2;
        this.zzAq();
        return googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                metadataChangeSet2.zzAD().setContext(zzahx2.getContext());
                zzahx2.zzAW().zza(new zzahb(zzahy.this.zzaNe.getDriveId(), metadataChangeSet2.zzAD(), zzahy.this.zzaNe.getRequestId(), zzahy.this.zzaNe.zzAn(), zzl3), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient googleApiClient) {
        if (this.zzAr()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzAq();
        (googleApiClient.zzb((zzaad.zza)new zzahw.zza(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                zzahx2.zzAW().zza(new zzahd(zzahy.this.zzaNe.getRequestId(), false), (zzaiy)new zzalc((zzaad.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(this){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzaic.zzG("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzaic.zzE("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public zzc zzAp() {
        return this.zzaNe;
    }

    @Override
    public void zzAq() {
        zzp.zza((ParcelFileDescriptor)this.zzaNe.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzAr() {
        return this.mClosed;
    }
}

