/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.internal.zzahz;
import com.google.android.gms.internal.zzaib;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzals;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzbxs;
import com.google.android.gms.internal.zzbxt;

public class DriveId
extends zza
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzh();
    final int zzaiI;
    final String zzaKS;
    final long zzaKT;
    final long zzaKB;
    final int zzaKU;
    private volatile String zzaKD = null;
    private volatile String zzaKV = null;

    public static DriveId zzdD(String string) {
        zzac.zzw((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaKS;
    }

    public int getResourceType() {
        return this.zzaKU;
    }

    public DriveFile asDriveFile() {
        if (this.zzaKU == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzahz(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaKU == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzaib(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaKU == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaKU == 0) {
            return this.asDriveFile();
        }
        return new zzaie(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    DriveId(int n, String string, long l, long l2, int n2) {
        this.zzaiI = n;
        this.zzaKS = string;
        zzac.zzax((!"".equals(string) ? 1 : 0) != 0);
        zzac.zzax((string != null || l != -1L ? 1 : 0) != 0);
        this.zzaKT = l;
        this.zzaKB = l2;
        this.zzaKU = n2;
    }

    public DriveId(String string, long l, long l2, int n) {
        this(1, string, l, l2, n);
    }

    public int hashCode() {
        if (this.zzaKT == -1L) {
            return this.zzaKS.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzaKB));
        String string2 = String.valueOf(String.valueOf(this.zzaKT));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzaKB != this.zzaKB) {
            return false;
        }
        if (driveId.zzaKT == -1L && this.zzaKT == -1L) {
            return driveId.zzaKS.equals(this.zzaKS);
        }
        if (this.zzaKS == null || driveId.zzaKS == null) {
            return driveId.zzaKT == this.zzaKT;
        }
        if (driveId.zzaKT == this.zzaKT) {
            if (driveId.zzaKS.equals(this.zzaKS)) {
                return true;
            }
            zzaic.zzF("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaKD == null) {
            byte[] byArray = this.zzAn();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzaKD = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzaKD;
    }

    public final String toInvariantString() {
        if (this.zzaKV == null) {
            byte[] byArray = this.zzAt();
            this.zzaKV = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaKV;
    }

    final byte[] zzAn() {
        zzals zzals2 = new zzals();
        zzals2.versionCode = this.zzaiI;
        zzals2.zzaOF = this.zzaKS == null ? "" : this.zzaKS;
        zzals2.zzaOG = this.zzaKT;
        zzals2.zzaOD = this.zzaKB;
        zzals2.zzaOH = this.zzaKU;
        byte[] byArray = zzbxt.zzf((zzbxt)zzals2);
        return byArray;
    }

    private byte[] zzAt() {
        zzalt zzalt2 = new zzalt();
        zzalt2.zzaOG = this.zzaKT;
        zzalt2.zzaOD = this.zzaKB;
        byte[] byArray = zzbxt.zzf((zzbxt)zzalt2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzac.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        String string3 = string.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string3, (int)10);
        return DriveId.zzt(byArray);
    }

    static DriveId zzt(byte[] byArray) {
        zzals zzals2;
        try {
            zzals2 = zzals.zzu(byArray);
        }
        catch (zzbxs zzbxs2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzals2.zzaOF) ? null : zzals2.zzaOF;
        DriveId driveId = new DriveId(zzals2.versionCode, string, zzals2.zzaOG, zzals2.zzaOD, zzals2.zzaOH);
        return driveId;
    }
}

