/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalw;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzaLk = new MetadataChangeSet(MetadataBundle.zzBx());
    private final MetadataBundle zzaLl;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzaLl = metadataBundle.zzBy();
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzaLl.zza(zzalu.zzaOZ);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzBs();
    }

    public String getDescription() {
        return this.zzaLl.zza(zzalu.zzaPa);
    }

    public String getIndexableText() {
        return this.zzaLl.zza(zzalu.zzaPg);
    }

    public Date getLastViewedByMeDate() {
        return this.zzaLl.zza(zzalw.zzaPQ);
    }

    public String getMimeType() {
        return this.zzaLl.zza(zzalu.zzaPu);
    }

    public String getTitle() {
        return this.zzaLl.zza(zzalu.zzaPD);
    }

    public Boolean isPinned() {
        return this.zzaLl.zza(zzalu.zzaPm);
    }

    public Boolean isStarred() {
        return this.zzaLl.zza(zzalu.zzaPB);
    }

    public Boolean isViewed() {
        return this.zzaLl.zza(zzalu.zzaPt);
    }

    public MetadataBundle zzAE() {
        return this.zzaLl;
    }

    public MetadataChangeSet zzAF() {
        return new MetadataChangeSet(this.zzAE());
    }

    public <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this.zzAF();
        metadataChangeSet.zzAE().zzc(metadataField, t);
        return metadataChangeSet;
    }

    public static class Builder {
        private final MetadataBundle zzaLl = MetadataBundle.zzBx();
        private AppVisibleCustomProperties.zza zzaLm;

        private AppVisibleCustomProperties.zza zzAG() {
            if (this.zzaLm == null) {
                this.zzaLm = new AppVisibleCustomProperties.zza();
            }
            return this.zzaLm;
        }

        private int zzdH(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzac.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzac.zzb((Object)string, (Object)"value");
            int n = this.zzdH(customPropertyKey.getKey()) + this.zzdH(string);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzAG().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzAG().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzaLl.zzc(zzalu.zzaPa, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = this.zzdH(string);
            this.zzk("Indexable text size", 131072, n);
            this.zzaLl.zzc(zzalu.zzaPg, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzaLl.zzc(zzalw.zzaPQ, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzaLl.zzc(zzalu.zzaPu, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzaLl.zzc(zzalu.zzaPm, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzaLl.zzc(zzalu.zzaPB, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzaLl.zzc(zzalu.zzaPD, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzaLl.zzc(zzalu.zzaPt, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzaLm != null) {
                this.zzaLl.zzc(zzalu.zzaOZ, this.zzaLm.zzBt());
            }
            return new MetadataChangeSet(this.zzaLl);
        }
    }
}

