/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzalu;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zza
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    final int zzaiI;
    final DriveId zzaKG;
    final String zzaiu;
    final ParcelFileDescriptor zzaLJ;
    final ParcelFileDescriptor zzaLK;
    final MetadataBundle zzaLL;
    final List<String> zzaLM;
    final int zzJO;
    final IBinder zzaLN;
    private boolean zzaLO = false;
    private boolean zzaLP = false;
    private boolean zzaLQ = false;

    CompletionEvent(int n, DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n2, IBinder iBinder) {
        this.zzaiI = n;
        this.zzaKG = driveId;
        this.zzaiu = string;
        this.zzaLJ = parcelFileDescriptor;
        this.zzaLK = parcelFileDescriptor2;
        this.zzaLL = metadataBundle;
        this.zzaLM = list;
        this.zzJO = n2;
        this.zzaLN = iBinder;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzg.zza(this, parcel, n | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzAN();
        return this.zzaKG;
    }

    public String getAccountName() {
        this.zzAN();
        return this.zzaiu;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzAN();
        if (this.zzaLJ == null) {
            return null;
        }
        if (this.zzaLO) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaLO = true;
        return new FileInputStream(this.zzaLJ.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzAN();
        if (this.zzaLK == null) {
            return null;
        }
        if (this.zzaLP) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaLP = true;
        return new FileInputStream(this.zzaLK.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzAN();
        return this.zzaLL != null ? new MetadataChangeSet(this.zzaLL) : null;
    }

    public List<String> getTrackingTags() {
        this.zzAN();
        return new ArrayList<String>(this.zzaLM);
    }

    public int getStatus() {
        this.zzAN();
        return this.zzJO;
    }

    public void dismiss() {
        this.zzx(false);
    }

    public void snooze() {
        this.zzx(true);
    }

    private void zzx(boolean bl) {
        this.zzAN();
        this.zzaLQ = true;
        zzp.zza((ParcelFileDescriptor)this.zzaLJ);
        zzp.zza((ParcelFileDescriptor)this.zzaLK);
        if (this.zzaLL != null && this.zzaLL.zzc(zzalu.zzaPC)) {
            this.zzaLL.zza(zzalu.zzaPC).release();
        }
        if (this.zzaLN == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzaic.zzG("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzaja.zza.zzbO(this.zzaLN).zzx(bl);
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzaic.zzG("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
        }
    }

    private void zzAN() {
        if (this.zzaLQ) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string;
        if (this.zzaLM == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.zzaLM));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzaKG, this.zzJO, string3});
    }
}

