/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzr;
import com.google.android.gms.drive.events.zzt;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzajp;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzd,
zzt {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzaLR;
    zza zzaLS;
    boolean zzaLT = false;
    int zzaEV = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzaLS == null && !this.zzaLT) {
                this.zzaLT = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzaLR = new CountDownLatch(1);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzaLS = new zza();
                            DriveEventService.this.zzaLT = false;
                            countDownLatch.countDown();
                            zzaic.zzE("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzaic.zzE("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzaLR != null) {
                                DriveEventService.this.zzaLR.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzaic.zzG("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzaic.zzE("DriveEventService", "onDestroy");
        if (this.zzaLS != null) {
            Message message = this.zzaLS.zzAP();
            this.zzaLS.sendMessage(message);
            this.zzaLS = null;
            try {
                boolean bl = this.zzaLR.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzaic.zzF("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {}
            this.zzaLR = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        String string = String.valueOf(changeEvent);
        zzaic.zzF(this.mName, new StringBuilder(24 + String.valueOf(string).length()).append("Unhandled change event: ").append(string).toString());
    }

    @Override
    public void zza(com.google.android.gms.drive.events.zzb zzb2) {
        String string = String.valueOf(zzb2);
        zzaic.zzF(this.mName, new StringBuilder(35 + String.valueOf(string).length()).append("Unhandled changes available event: ").append(string).toString());
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        String string = String.valueOf(completionEvent);
        zzaic.zzF(this.mName, new StringBuilder(28 + String.valueOf(string).length()).append("Unhandled completion event: ").append(string).toString());
    }

    public void zza(zzr zzr2) {
        String string = String.valueOf(zzr2);
        zzaic.zzF(this.mName, new StringBuilder(32 + String.valueOf(string).length()).append("Unhandled transfer state event: ").append(string).toString());
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(zzajp zzajp2) {
        DriveEvent driveEvent = zzajp2.zzBi();
        String string = String.valueOf(driveEvent);
        zzaic.zzE("DriveEventService", new StringBuilder(20 + String.valueOf(string).length()).append("handleEventMessage: ").append(string).toString());
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((com.google.android.gms.drive.events.zzb)driveEvent);
                    break;
                }
                case 7: {
                    this.zza((zzr)driveEvent);
                    break;
                }
                default: {
                    string = String.valueOf(driveEvent);
                    zzaic.zzF(this.mName, new StringBuilder(17 + String.valueOf(string).length()).append("Unhandled event: ").append(string).toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            String string2 = String.valueOf(driveEvent);
            zzaic.zza(this.mName, exception, new StringBuilder(22 + String.valueOf(string2).length()).append("Error handling event: ").append(string2).toString());
        }
    }

    private void zzAO() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzaEV) {
            return;
        }
        if (zzy.zzf((Context)this, (int)n)) {
            this.zzaEV = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzaiz.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(zzajp zzajp2) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                String string = String.valueOf((Object)zzajp2);
                zzaic.zzE("DriveEventService", new StringBuilder(9 + String.valueOf(string).length()).append("onEvent: ").append(string).toString());
                DriveEventService.this.zzAO();
                if (DriveEventService.this.zzaLS != null) {
                    string = DriveEventService.this.zzaLS.zzb(zzajp2);
                    DriveEventService.this.zzaLS.sendMessage((Message)string);
                } else {
                    zzaic.zzG("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(zzajp zzajp2) {
            return this.obtainMessage(1, (Object)zzajp2);
        }

        private Message zzAP() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message message) {
            int n = message.what;
            zzaic.zzE("DriveEventService", new StringBuilder(38).append("handleMessage message type:").append(n).toString());
            switch (message.what) {
                case 1: {
                    DriveEventService.this.zza((zzajp)((Object)message.obj));
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    n = message.what;
                    zzaic.zzF("DriveEventService", new StringBuilder(35).append("Unexpected message type:").append(n).toString());
                }
            }
        }
    }
}

