/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.zzk;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzahz;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajn;
import com.google.android.gms.internal.zzalu;

public class zzaib
extends zzaie
implements DriveFolder {
    public zzaib(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        return new zzahv().query(googleApiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, zzk.zza(executionOptions));
    }

    private void zzb(MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzj zzj2 = zzj.zzdK(metadataChangeSet.getMimeType());
        if (zzj2 != null && !zzj2.zzBA()) {
            throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
        }
    }

    public PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzk zzk2) {
        if (zzk2 == null) {
            zzk2 = (zzk)new zzk.zza().build();
        }
        this.zzb(googleApiClient, metadataChangeSet, driveContents, zzk2);
        zzj zzj2 = zzj.zzdK(metadataChangeSet.getMimeType());
        int n = this.zza(driveContents, zzj2);
        String string = zzk2.zzAz();
        if (string != null) {
            metadataChangeSet = this.zza(metadataChangeSet, string);
        }
        return this.zza(googleApiClient, metadataChangeSet, n, zzk2);
    }

    private MetadataChangeSet zza(MetadataChangeSet metadataChangeSet, String string) {
        return metadataChangeSet.zza(zzalu.zzaPH, string);
    }

    private int zza(DriveContents driveContents, zzj zzj2) {
        int n;
        if (driveContents == null) {
            n = zzj2 != null && zzj2.zzBB() ? 0 : 1;
        } else {
            n = driveContents.zzAq().getRequestId();
            driveContents.zzAr();
        }
        return n;
    }

    private void zzb(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzk zzk2) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzj zzj2 = zzj.zzdK(metadataChangeSet.getMimeType());
        if (zzj2 != null && zzj2.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        zzk2.zzh(googleApiClient);
        if (driveContents == null) {
            return;
        }
        if (!(driveContents instanceof zzahy)) {
            throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
        }
        if (driveContents.getDriveId() != null) {
            throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
        }
        if (driveContents.zzAs()) {
            throw new IllegalArgumentException("DriveContents are already closed.");
        }
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final zzk zzk2) {
        zzj zzj2 = zzj.zzdK(metadataChangeSet.getMimeType());
        final int n2 = zzj2 != null && zzj2.zzBB() ? 1 : 0;
        return googleApiClient.zzb((zzaad.zza)new zzd(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                metadataChangeSet.zzAE().setContext(zzahx2.getContext());
                zzahm zzahm2 = new zzahm(zzaib.this.getDriveId(), metadataChangeSet.zzAE(), n, n2, zzk2);
                zzahx2.zzAX().zza(zzahm2, (zzaiy)new zza((zzaad.zzb<DriveFolder.DriveFileResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return googleApiClient.zzb((zzaad.zza)new zzf(googleApiClient){

            protected void zza(zzahx zzahx2) throws RemoteException {
                metadataChangeSet.zzAE().setContext(zzahx2.getContext());
                zzahx2.zzAX().zza(new zzaho(zzaib.this.getDriveId(), metadataChangeSet.zzAE()), (zzaiy)new zzb((zzaad.zzb<DriveFolder.DriveFolderResult>)this));
            }
        });
    }

    private static class zzb
    extends zzagu {
        private final zzaad.zzb<DriveFolder.DriveFolderResult> zzaGN;

        public zzb(zzaad.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajn zzajn2) throws RemoteException {
            this.zzaGN.setResult((Object)new zze(Status.zzazx, new zzaib(zzajn2.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status zzair;
        private final DriveFolder zzaNv;

        public zze(Status status, DriveFolder driveFolder) {
            this.zzair = status;
            this.zzaNv = driveFolder;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.zzaNv;
        }
    }

    static abstract class zzf
    extends zzahw<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzR(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzR(status);
        }
    }

    private static class zza
    extends zzagu {
        private final zzaad.zzb<DriveFolder.DriveFileResult> zzaGN;

        public zza(zzaad.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zza(zzajn zzajn2) throws RemoteException {
            this.zzaGN.setResult((Object)new zzc(Status.zzazx, new zzahz(zzajn2.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzaGN.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status zzair;
        private final DriveFile zzaNu;

        public zzc(Status status, DriveFile driveFile) {
            this.zzair = status;
            this.zzaNu = driveFile;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.zzaNu;
        }
    }

    static abstract class zzd
    extends zzahw<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzQ(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzQ(status);
        }
    }
}

