/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzp;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzboa;
import com.google.android.gms.internal.zzbob;
import com.google.android.gms.internal.zzboc;
import com.google.android.gms.internal.zzbod;
import java.io.InputStream;
import java.io.OutputStream;

public final class zzbnz
implements DriveContents {
    private final zzc zzaOk;
    private boolean mClosed = false;
    private boolean zzaOl = false;
    private boolean zzaOm = false;

    public zzbnz(zzc zzc2) {
        this.zzaOk = (zzc)((Object)zzbr.zzu((Object)((Object)zzc2)));
    }

    @Override
    public final DriveId getDriveId() {
        return this.zzaOk.getDriveId();
    }

    @Override
    public final int getMode() {
        return this.zzaOk.getMode();
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaOk.getParcelFileDescriptor();
    }

    @Override
    public final InputStream getInputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaOk.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaOl) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaOl = true;
        return this.zzaOk.getInputStream();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaOk.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaOm) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaOm = true;
        return this.zzaOk.getOutputStream();
    }

    @Override
    public final PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaOk.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzsM();
        return googleApiClient.zzd((zzbck)new zzboa(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        zzp zzp2;
        if (executionOptions == null) {
            zzp2 = null;
        } else {
            ExecutionOptions executionOptions2 = executionOptions;
            zzr zzr2 = new zzr();
            if (executionOptions2 != null) {
                zzr2.setConflictStrategy(executionOptions2.zzsQ());
                zzr2.setNotifyOnCompletion(executionOptions2.zzsP());
                String string = executionOptions2.zzsO();
                if (string != null) {
                    zzr2.setTrackingTag(string);
                }
            }
            zzp2 = (zzp)zzr2.build();
        }
        return this.zza(googleApiClient, metadataChangeSet, zzp2);
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzp zzp2) {
        boolean bl;
        if (zzp2 == null) {
            zzp2 = (zzp)new zzr().build();
        }
        if (this.zzaOk.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        switch (zzp2.zzsQ()) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && !this.zzaOk.zzsJ()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzp2.zze(googleApiClient);
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzaMD;
        zzp zzp3 = zzp2;
        this.zzsM();
        return googleApiClient.zze((zzbck)new zzbob(this, googleApiClient, metadataChangeSet2, zzp3));
    }

    @Override
    public final void discard(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzsM();
        ((zzbod)googleApiClient.zze((zzbck)new zzbod(this, googleApiClient))).setResultCallback(new zzboc(this));
    }

    @Override
    public final zzc zzsL() {
        return this.zzaOk;
    }

    @Override
    public final void zzsM() {
        com.google.android.gms.common.util.zzp.zza((ParcelFileDescriptor)this.zzaOk.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public final boolean zzsN() {
        return this.mClosed;
    }

    static /* synthetic */ zzc zza(zzbnz zzbnz2) {
        return zzbnz2.zzaOk;
    }
}

