/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmy;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnu;
import com.google.android.gms.internal.zzbnv;
import com.google.android.gms.internal.zzbnw;
import com.google.android.gms.internal.zzbpo;
import com.google.android.gms.internal.zzbpy;
import com.google.android.gms.internal.zzbpz;
import com.google.android.gms.internal.zzbrw;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzbnt
extends zzaa<zzbpy> {
    private final String zzakg;
    private final Bundle zzaNU;
    private final boolean zzaNV;
    private volatile DriveId zzaNW;
    private volatile DriveId zzaNX;
    private volatile boolean zzaNY = false;
    private GoogleApiClient.ConnectionCallbacks zzaNZ;
    private Map<DriveId, Map<ChangeListener, zzbpo>> zzaOa = new HashMap<DriveId, Map<ChangeListener, zzbpo>>();
    private Map<zzd, zzbpo> zzaOb = new HashMap<zzd, zzbpo>();
    private Map<DriveId, Map<Object, zzbpo>> zzaOc = new HashMap<DriveId, Map<Object, zzbpo>>();
    private Map<DriveId, Map<Object, zzbpo>> zzaOd = new HashMap<DriveId, Map<Object, zzbpo>>();

    public zzbnt(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzakg = zzq2.zzro();
        this.zzaNZ = connectionCallbacks;
        this.zzaNU = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaNV = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaNV = true;
                return;
            }
        }
        String string = String.valueOf(intent.getAction());
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzmt() {
        return !this.getContext().getPackageName().equals(this.zzakg) || !zzy.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzre() {
        return true;
    }

    protected final String zzdb() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzmm() {
        String string = this.getContext().getPackageName();
        zzbr.zzu((Object)string);
        zzbr.zzae((!this.zzrx().zzrm().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzakg)) {
            bundle.putString("proxy_package_name", this.zzakg);
        }
        bundle.putAll(this.zzaNU);
        return bundle;
    }

    protected final String zzda() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zzte() {
        return this.zzaNW;
    }

    public final DriveId zztf() {
        return this.zzaNX;
    }

    public final boolean zztg() {
        return this.zzaNY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzbpy)this.zzrd()).zza(new zzbmy());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzaOa;
        synchronized (map) {
            this.zzaOa.clear();
        }
        map = this.zzaOb;
        synchronized (map) {
            this.zzaOb.clear();
        }
        map = this.zzaOc;
        synchronized (map) {
            this.zzaOc.clear();
        }
        map = this.zzaOd;
        synchronized (map) {
            this.zzaOd.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaNW = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaNX = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaNY = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzth() {
        return this.zzaNV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbr.zzaf((boolean)zzj.zza(1, driveId));
        zzbr.zzb((Object)changeListener, (Object)"listener");
        zzbr.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbpo>> map = this.zzaOa;
        synchronized (map) {
            zzbpo zzbpo2;
            Map<ChangeListener, zzbpo> map2 = this.zzaOa.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbpo>();
                this.zzaOa.put(driveId, map2);
            }
            if ((zzbpo2 = map2.get(changeListener)) == null) {
                zzbpo2 = new zzbpo(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzbpo2);
            } else if (zzbpo2.zzaO(1)) {
                return new zzbnq(googleApiClient, Status.zzaBo);
            }
            zzbpo2.zzaN(1);
            zzbpo zzbpo3 = zzbpo2;
            zzbmd zzbmd2 = new zzbmd(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnt zzbnt2 = this;
            return googleApiClient2.zze((zzbck)new zzbnu(zzbnt2, googleApiClient2, zzbmd2, zzbpo3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbr.zzaf((boolean)zzj.zza(1, driveId));
        zzbr.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbr.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbpo>> map = this.zzaOa;
        synchronized (map) {
            Map<ChangeListener, zzbpo> map2 = this.zzaOa.get((Object)driveId);
            if (map2 == null) {
                return new zzbnq(googleApiClient, Status.zzaBo);
            }
            zzbpo zzbpo2 = map2.remove(changeListener);
            if (zzbpo2 == null) {
                return new zzbnq(googleApiClient, Status.zzaBo);
            }
            if (map2.isEmpty()) {
                this.zzaOa.remove((Object)driveId);
            }
            zzbpo zzbpo3 = zzbpo2;
            zzbrw zzbrw2 = new zzbrw(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbnt zzbnt2 = this;
            return googleApiClient2.zze((zzbck)new zzbnv(zzbnt2, googleApiClient2, zzbrw2, zzbpo3));
        }
    }

    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        zzbmd zzbmd2 = new zzbmd(1, driveId);
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbnt zzbnt2 = this;
        zzbr.zzaf((boolean)zzj.zza(zzbmd2.zzaJq, zzbmd2.zzaLZ));
        zzbr.zza((boolean)zzbnt2.isConnected(), (Object)"Client must be connected");
        if (!zzbnt2.zzaNV) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient2.zze((zzbck)new zzbnw(zzbnt2, googleApiClient2, zzbmd2));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbpy) {
            return (zzbpy)iInterface;
        }
        return new zzbpz(iBinder2);
    }
}

