/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbnt;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaMv;
    private final boolean zzaMw;
    private final int zzaMx;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzaMv = string;
        this.zzaMw = bl;
        this.zzaMx = n;
    }

    public final String zzsO() {
        return this.zzaMv;
    }

    public final boolean zzsP() {
        return this.zzaMw;
    }

    public final int zzsQ() {
        return this.zzaMx;
    }

    public final void zze(GoogleApiClient googleApiClient) {
        zzbnt zzbnt2 = (zzbnt)googleApiClient.zza(Drive.zzajT);
        if (this.zzaMw && !zzbnt2.zzth()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbh.equal((Object)this.zzaMv, (Object)executionOptions.zzaMv) && this.zzaMx == executionOptions.zzaMx && this.zzaMw == executionOptions.zzaMw;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaMv, this.zzaMx, this.zzaMw});
    }

    public static class Builder {
        protected String zzaMv;
        protected boolean zzaMw;
        protected int zzaMx = 0;

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaMv = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzaMw = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzaMx = n;
            return this;
        }

        protected final void zzsR() {
            if (this.zzaMx == 1 && !this.zzaMw) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzsR();
            return new ExecutionOptions(this.zzaMv, this.zzaMw, this.zzaMx);
        }
    }
}

