/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbqf;
import com.google.android.gms.internal.zzbso;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zza
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzaLZ;
    private String zzakj;
    private ParcelFileDescriptor zzaNa;
    private ParcelFileDescriptor zzaNb;
    private MetadataBundle zzaNc;
    private List<String> zzaNd;
    private int zzLj;
    private IBinder zzaNe;
    private boolean zzaNf = false;
    private boolean zzaNg = false;
    private boolean zzaNh = false;

    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzaLZ = driveId;
        this.zzakj = string;
        this.zzaNa = parcelFileDescriptor;
        this.zzaNb = parcelFileDescriptor2;
        this.zzaNc = metadataBundle;
        this.zzaNd = list;
        this.zzLj = n;
        this.zzaNe = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzaLZ, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzakj, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzaNa, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zzaNb, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzaNc, (int)n2, (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)7, completionEvent.zzaNd, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)completionEvent.zzLj);
        zzd.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzaNe, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n3);
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzsX();
        return this.zzaLZ;
    }

    public final String getAccountName() {
        this.zzsX();
        return this.zzakj;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzsX();
        if (this.zzaNa == null) {
            return null;
        }
        if (this.zzaNf) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaNf = true;
        return new FileInputStream(this.zzaNa.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzsX();
        if (this.zzaNb == null) {
            return null;
        }
        if (this.zzaNg) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaNg = true;
        return new FileInputStream(this.zzaNb.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzsX();
        if (this.zzaNc != null) {
            return new MetadataChangeSet(this.zzaNc);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzsX();
        return new ArrayList<String>(this.zzaNd);
    }

    public final int getStatus() {
        this.zzsX();
        return this.zzLj;
    }

    public final void dismiss() {
        this.zzq(false);
    }

    public final void snooze() {
        this.zzq(true);
    }

    private final void zzq(boolean bl) {
        this.zzsX();
        this.zzaNh = true;
        zzp.zza((ParcelFileDescriptor)this.zzaNa);
        zzp.zza((ParcelFileDescriptor)this.zzaNb);
        if (this.zzaNc != null && this.zzaNc.zzc(zzbso.zzaQz)) {
            this.zzaNc.zza(zzbso.zzaQz).release();
        }
        if (this.zzaNe == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzbos.zzz("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzbqf.zzK(this.zzaNe).zzq(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzbos.zzz("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
            return;
        }
    }

    private final void zzsX() {
        if (this.zzaNh) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzaNd == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.zzaNd));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzaLZ, this.zzLj, string3});
    }
}

