/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbrb;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zza
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzaLV;
    private String zzakh;
    private ParcelFileDescriptor zzaMW;
    private ParcelFileDescriptor zzaMX;
    private MetadataBundle zzaMY;
    private List<String> zzaMZ;
    private int zzLg;
    private IBinder zzaNa;
    private boolean zzaNb = false;
    private boolean zzaNc = false;
    private boolean zzaNd = false;

    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzaLV = driveId;
        this.zzakh = string;
        this.zzaMW = parcelFileDescriptor;
        this.zzaMX = parcelFileDescriptor2;
        this.zzaMY = metadataBundle;
        this.zzaMZ = list;
        this.zzLg = n;
        this.zzaNa = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzaLV, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzakh, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzaMW, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zzaMX, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzaMY, (int)n2, (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)7, completionEvent.zzaMZ, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)completionEvent.zzLg);
        zzd.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzaNa, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n3);
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzsY();
        return this.zzaLV;
    }

    public final String getAccountName() {
        this.zzsY();
        return this.zzakh;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzsY();
        if (this.zzaMW == null) {
            return null;
        }
        if (this.zzaNb) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaNb = true;
        return new FileInputStream(this.zzaMW.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzsY();
        if (this.zzaMX == null) {
            return null;
        }
        if (this.zzaNc) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzaNc = true;
        return new FileInputStream(this.zzaMX.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzsY();
        if (this.zzaMY != null) {
            return new MetadataChangeSet(this.zzaMY);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzsY();
        return new ArrayList<String>(this.zzaMZ);
    }

    public final int getStatus() {
        this.zzsY();
        return this.zzLg;
    }

    public final void dismiss() {
        this.zzq(false);
    }

    public final void snooze() {
        this.zzq(true);
    }

    private final void zzq(boolean bl) {
        this.zzsY();
        this.zzaNd = true;
        zzn.zza((ParcelFileDescriptor)this.zzaMW);
        zzn.zza((ParcelFileDescriptor)this.zzaMX);
        if (this.zzaMY != null && this.zzaMY.zzc(zzbrb.zzaQv)) {
            this.zzaMY.zza(zzbrb.zzaQv).release();
        }
        if (this.zzaNa == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzbnf.zzz("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzbos.zzK(this.zzaNa).zzq(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzbnf.zzz("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
            return;
        }
    }

    private final void zzsY() {
        if (this.zzaNd) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzaMZ == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.zzaMZ));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzaLV, this.zzLg, string3});
    }
}

