/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzk;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.zzm;
import com.google.android.gms.drive.zzo;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbln;
import com.google.android.gms.internal.zzbmm;
import com.google.android.gms.internal.zzbmx;
import com.google.android.gms.internal.zzbmy;
import com.google.android.gms.internal.zzbnm;
import com.google.android.gms.internal.zzbrb;

public final class zzbmw
extends zzbnm
implements DriveFolder {
    public zzbmw(DriveId driveId) {
        super(driveId);
    }

    @Override
    public final PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    @Override
    public final PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        zzbln zzbln2 = new zzbln();
        Query query2 = query;
        zzbmw zzbmw2 = this;
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, zzbmw2.getDriveId()));
        if (query2 != null) {
            if (query2.getFilter() != null) {
                builder.addFilter(query2.getFilter());
            }
            builder.setPageToken(query2.getPageToken());
            builder.setSortOrder(query2.getSortOrder());
        }
        return zzbln2.query(googleApiClient, builder.build());
    }

    @Override
    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        zzbmw.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, null);
    }

    @Override
    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        zzbmw.zzb(metadataChangeSet);
        ExecutionOptions executionOptions2 = executionOptions;
        zzo zzo2 = new zzo();
        if (executionOptions2 != null) {
            if (executionOptions2.zzsR() != 0) {
                throw new IllegalStateException("May not set a conflict strategy for new file creation.");
            }
            String string = executionOptions2.zzsP();
            if (string != null) {
                zzo2.setTrackingTag(string);
            }
            zzo2.setNotifyOnCompletion(executionOptions2.zzsQ());
        }
        return this.zza(googleApiClient, metadataChangeSet, driveContents, (zzm)zzo2.build());
    }

    private static void zzb(MetadataChangeSet metadataChangeSet) {
        zzk zzk2;
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzk zzk3 = zzk.zzcS(metadataChangeSet.getMimeType());
        if (zzk3 != null && !(!(zzk2 = zzk3).zzts() && !zzk2.isFolder())) {
            throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
        }
    }

    private final PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzm zzm2) {
        int n;
        if (zzm2 == null) {
            zzm2 = (zzm)new zzo().build();
        }
        zzm zzm3 = zzm2;
        Object object = driveContents;
        Object object2 = metadataChangeSet;
        Object object3 = googleApiClient;
        if (object2 == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzk zzk2 = zzk.zzcS(((MetadataChangeSet)object2).getMimeType());
        if (zzk2 != null && zzk2.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        zzm3.zze((GoogleApiClient)object3);
        if (object != null) {
            if (!(object instanceof zzbmm)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (object.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (object.zzsO()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
        }
        zzk zzk3 = zzk.zzcS(metadataChangeSet.getMimeType());
        object2 = zzk3;
        object3 = driveContents;
        if (object3 == null) {
            n = object2 != null && ((zzk)object2).zzts() ? 0 : 1;
        } else {
            n = object3.zzsM().getRequestId();
            object3.zzsN();
        }
        int n2 = n;
        String string = zzm2.zzsU();
        if (string != null) {
            object2 = string;
            metadataChangeSet = metadataChangeSet.zza(zzbrb.zzaQA, object2);
        }
        zzm zzm4 = zzm2;
        n = n2;
        object = metadataChangeSet;
        object2 = googleApiClient;
        object3 = this;
        zzk2 = zzk.zzcS(((MetadataChangeSet)object).getMimeType());
        int n3 = zzk2 != null && zzk2.zzts() ? 1 : 0;
        return object2.zze((zzbax)new zzbmx((zzbmw)object3, (GoogleApiClient)object2, (MetadataChangeSet)object, n, n3, zzm4));
    }

    @Override
    public final PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return googleApiClient.zze((zzbax)new zzbmy(this, googleApiClient, metadataChangeSet));
    }
}

