/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbrb;
import com.google.android.gms.internal.zzbro;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzaMz = new MetadataChangeSet(MetadataBundle.zztp());
    private final MetadataBundle zzaMA;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzaMA = metadataBundle.zztq();
    }

    public final Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzaMA.zza(zzbrb.zzaPS);
        if (appVisibleCustomProperties == null) {
            return Collections.emptyMap();
        }
        return appVisibleCustomProperties.zztl();
    }

    public final String getDescription() {
        return this.zzaMA.zza(zzbrb.zzaPT);
    }

    public final String getIndexableText() {
        return this.zzaMA.zza(zzbrb.zzaPZ);
    }

    public final Date getLastViewedByMeDate() {
        return this.zzaMA.zza(zzbro.zzaQJ);
    }

    public final String getMimeType() {
        return this.zzaMA.zza(zzbrb.zzaQn);
    }

    public final String getTitle() {
        return this.zzaMA.zza(zzbrb.zzaQw);
    }

    public final Boolean isPinned() {
        return this.zzaMA.zza(zzbrb.zzaQf);
    }

    public final Boolean isStarred() {
        return this.zzaMA.zza(zzbrb.zzaQu);
    }

    public final Boolean isViewed() {
        return this.zzaMA.zza(zzbrb.zzaQm);
    }

    public final MetadataBundle zzsW() {
        return this.zzaMA;
    }

    public final <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this;
        MetadataChangeSet metadataChangeSet2 = new MetadataChangeSet(metadataChangeSet.zzaMA);
        metadataChangeSet2.zzaMA.zzc(metadataField, t);
        return metadataChangeSet2;
    }

    public static class Builder {
        private final MetadataBundle zzaMA = MetadataBundle.zztp();
        private AppVisibleCustomProperties.zza zzaMB;

        private final AppVisibleCustomProperties.zza zzsX() {
            if (this.zzaMB == null) {
                this.zzaMB = new AppVisibleCustomProperties.zza();
            }
            return this.zzaMB;
        }

        private static int zzcP(String string) {
            if (string == null) {
                return 0;
            }
            return string.getBytes().length;
        }

        private static void zzi(String string, int n, int n2) {
            int n3 = n2;
            int n4 = n;
            String string2 = string;
            zzbo.zzb((n2 <= n ? 1 : 0) != 0, (Object)String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n4, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzbo.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzbo.zzb((Object)string, (Object)"value");
            int n = Builder.zzcP(customPropertyKey.getKey()) + Builder.zzcP(string);
            Builder.zzi("The total size of key string and value string of a custom property", 124, n);
            this.zzsX().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzbo.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzsX().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzaMA.zzc(zzbrb.zzaPT, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = Builder.zzcP(string);
            Builder.zzi("Indexable text size", 131072, n);
            this.zzaMA.zzc(zzbrb.zzaPZ, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzaMA.zzc(zzbro.zzaQJ, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzaMA.zzc(zzbrb.zzaQn, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzaMA.zzc(zzbrb.zzaQf, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzaMA.zzc(zzbrb.zzaQu, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzaMA.zzc(zzbrb.zzaQw, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzaMA.zzc(zzbrb.zzaQm, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzaMB != null) {
                this.zzaMA.zzc(zzbrb.zzaPS, this.zzaMB.zztm());
            }
            return new MetadataChangeSet(this.zzaMA);
        }
    }
}

