/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbkq;
import com.google.android.gms.internal.zzbll;
import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmh;
import com.google.android.gms.internal.zzbmi;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbob;
import com.google.android.gms.internal.zzbol;
import com.google.android.gms.internal.zzbom;
import com.google.android.gms.internal.zzbqj;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzbmg
extends zzz<zzbol> {
    private final String zzake;
    private final Bundle zzaNQ;
    private final boolean zzaNR;
    private volatile DriveId zzaNS;
    private volatile DriveId zzaNT;
    private volatile boolean zzaNU = false;
    private GoogleApiClient.ConnectionCallbacks zzaNV;
    private Map<DriveId, Map<ChangeListener, zzbob>> zzaNW = new HashMap<DriveId, Map<ChangeListener, zzbob>>();
    private Map<zzd, zzbob> zzaNX = new HashMap<zzd, zzbob>();
    private Map<DriveId, Map<Object, zzbob>> zzaNY = new HashMap<DriveId, Map<Object, zzbob>>();
    private Map<DriveId, Map<Object, zzbob>> zzaNZ = new HashMap<DriveId, Map<Object, zzbob>>();

    public zzbmg(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzake = zzq2.zzrq();
        this.zzaNV = connectionCallbacks;
        this.zzaNQ = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaNR = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaNR = true;
                return;
            }
        }
        String string = String.valueOf(intent.getAction());
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzmv() {
        return !this.getContext().getPackageName().equals(this.zzake) || !zzw.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzrg() {
        return true;
    }

    protected final String zzdc() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzmo() {
        String string = this.getContext().getPackageName();
        zzbo.zzu((Object)string);
        zzbo.zzae((!this.zzry().zzro().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzake)) {
            bundle.putString("proxy_package_name", this.zzake);
        }
        bundle.putAll(this.zzaNQ);
        return bundle;
    }

    protected final String zzdb() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zztf() {
        return this.zzaNS;
    }

    public final DriveId zztg() {
        return this.zzaNT;
    }

    public final boolean zzth() {
        return this.zzaNU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzbol)this.zzrf()).zza(new zzbll());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzaNW;
        synchronized (map) {
            this.zzaNW.clear();
        }
        map = this.zzaNX;
        synchronized (map) {
            this.zzaNX.clear();
        }
        map = this.zzaNY;
        synchronized (map) {
            this.zzaNY.clear();
        }
        map = this.zzaNZ;
        synchronized (map) {
            this.zzaNZ.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaNS = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaNT = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaNU = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzti() {
        return this.zzaNR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbo.zzaf((boolean)zzj.zza(1, driveId));
        zzbo.zzb((Object)changeListener, (Object)"listener");
        zzbo.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzbob>> map = this.zzaNW;
        synchronized (map) {
            zzbob zzbob2;
            Map<ChangeListener, zzbob> map2 = this.zzaNW.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzbob>();
                this.zzaNW.put(driveId, map2);
            }
            if ((zzbob2 = map2.get(changeListener)) == null) {
                zzbob2 = new zzbob(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzbob2);
            } else if (zzbob2.zzaO(1)) {
                return new zzbmd(googleApiClient, Status.zzaBm);
            }
            zzbob2.zzaN(1);
            zzbob zzbob3 = zzbob2;
            zzbkq zzbkq2 = new zzbkq(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmg zzbmg2 = this;
            return googleApiClient2.zze((zzbax)new zzbmh(zzbmg2, googleApiClient2, zzbkq2, zzbob3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbo.zzaf((boolean)zzj.zza(1, driveId));
        zzbo.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbo.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzbob>> map = this.zzaNW;
        synchronized (map) {
            Map<ChangeListener, zzbob> map2 = this.zzaNW.get((Object)driveId);
            if (map2 == null) {
                return new zzbmd(googleApiClient, Status.zzaBm);
            }
            zzbob zzbob2 = map2.remove(changeListener);
            if (zzbob2 == null) {
                return new zzbmd(googleApiClient, Status.zzaBm);
            }
            if (map2.isEmpty()) {
                this.zzaNW.remove((Object)driveId);
            }
            zzbob zzbob3 = zzbob2;
            zzbqj zzbqj2 = new zzbqj(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmg zzbmg2 = this;
            return googleApiClient2.zze((zzbax)new zzbmi(zzbmg2, googleApiClient2, zzbqj2, zzbob3));
        }
    }

    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        zzbkq zzbkq2 = new zzbkq(1, driveId);
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbmg zzbmg2 = this;
        zzbo.zzaf((boolean)zzj.zza(zzbkq2.zzaJo, zzbkq2.zzaLV));
        zzbo.zza((boolean)zzbmg2.isConnected(), (Object)"Client must be connected");
        if (!zzbmg2.zzaNR) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient2.zze((zzbax)new zzbmj(zzbmg2, googleApiClient2, zzbkq2));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbol) {
            return (zzbol)iInterface;
        }
        return new zzbom(iBinder2);
    }
}

