/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zzf;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbrb;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzj();
    private Bundle zzaPM;

    MetadataBundle(Bundle bundle) {
        this.zzaPM = (Bundle)zzbo.zzu((Object)bundle);
        this.zzaPM.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzaPM.keySet()) {
            if (zzf.zzcR(string) != null) continue;
            arrayList.add(string);
            String string2 = String.valueOf(string);
            zzbnf.zzy("MetadataBundle", string2.length() != 0 ? "Ignored unknown metadata field in bundle: ".concat(string2) : new String("Ignored unknown metadata field in bundle: "));
        }
        ArrayList<String> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object e = arrayList2.get(i);
            string = (String)e;
            this.zzaPM.remove(string);
        }
    }

    public static MetadataBundle zztp() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zztp();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public final MetadataBundle zztq() {
        return new MetadataBundle(new Bundle(this.zzaPM));
    }

    public final <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zzf.zzcR(metadataField.getName()) == null) {
            String string = String.valueOf(metadataField.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.zzaPM);
    }

    public final <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzp(this.zzaPM);
    }

    public final boolean zzc(MetadataField<?> metadataField) {
        return this.zzaPM.containsKey(metadataField.getName());
    }

    public final Set<MetadataField<?>> zztr() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzaPM.keySet()) {
            hashSet.add(zzf.zzcR(string));
        }
        return hashSet;
    }

    public final void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzbrb.zzaQv);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public final int hashCode() {
        int n = 1;
        for (String string : this.zzaPM.keySet()) {
            n = n * 31 + this.zzaPM.get(string).hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.zzaPM.keySet();
        if (!set.equals(metadataBundle.zzaPM.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzbe.equal((Object)this.zzaPM.get(string), (Object)metadataBundle.zzaPM.get(string))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzaPM);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MetadataBundle metadataBundle = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Bundle)metadataBundle.zzaPM, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

