/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzd;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbkr;
import com.google.android.gms.internal.zzblm;
import com.google.android.gms.internal.zzbme;
import com.google.android.gms.internal.zzbmi;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbmk;
import com.google.android.gms.internal.zzboc;
import com.google.android.gms.internal.zzbom;
import com.google.android.gms.internal.zzbon;
import com.google.android.gms.internal.zzbqk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzbmh
extends zzz<zzbom> {
    private final String zzake;
    private final Bundle zzaNQ;
    private final boolean zzaNR;
    private volatile DriveId zzaNS;
    private volatile DriveId zzaNT;
    private volatile boolean zzaNU = false;
    private GoogleApiClient.ConnectionCallbacks zzaNV;
    private Map<DriveId, Map<ChangeListener, zzboc>> zzaNW = new HashMap<DriveId, Map<ChangeListener, zzboc>>();
    private Map<zzd, zzboc> zzaNX = new HashMap<zzd, zzboc>();
    private Map<DriveId, Map<Object, zzboc>> zzaNY = new HashMap<DriveId, Map<Object, zzboc>>();
    private Map<DriveId, Map<Object, zzboc>> zzaNZ = new HashMap<DriveId, Map<Object, zzboc>>();

    public zzbmh(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzake = zzq2.zzrq();
        this.zzaNV = connectionCallbacks;
        this.zzaNQ = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaNR = false;
                return;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaNR = true;
                return;
            }
        }
        String string = String.valueOf(intent.getAction());
        throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
    }

    public final boolean zzmv() {
        return !this.getContext().getPackageName().equals(this.zzake) || !zzw.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    public final boolean zzrg() {
        return true;
    }

    protected final String zzdc() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected final Bundle zzmo() {
        String string = this.getContext().getPackageName();
        zzbo.zzu((Object)string);
        zzbo.zzae((!this.zzry().zzro().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzake)) {
            bundle.putString("proxy_package_name", this.zzake);
        }
        bundle.putAll(this.zzaNQ);
        return bundle;
    }

    protected final String zzdb() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public final DriveId zztf() {
        return this.zzaNS;
    }

    public final DriveId zztg() {
        return this.zzaNT;
    }

    public final boolean zzth() {
        return this.zzaNU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzbom)this.zzrf()).zza(new zzblm());
            }
            catch (RemoteException remoteException) {}
        }
        super.disconnect();
        Map<Object, Object> map = this.zzaNW;
        synchronized (map) {
            this.zzaNW.clear();
        }
        map = this.zzaNX;
        synchronized (map) {
            this.zzaNX.clear();
        }
        map = this.zzaNY;
        synchronized (map) {
            this.zzaNY.clear();
        }
        map = this.zzaNZ;
        synchronized (map) {
            this.zzaNZ.clear();
            return;
        }
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaNS = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaNT = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaNU = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final boolean zzti() {
        return this.zzaNR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbo.zzaf((boolean)zzj.zza(1, driveId));
        zzbo.zzb((Object)changeListener, (Object)"listener");
        zzbo.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzboc>> map = this.zzaNW;
        synchronized (map) {
            zzboc zzboc2;
            Map<ChangeListener, zzboc> map2 = this.zzaNW.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzboc>();
                this.zzaNW.put(driveId, map2);
            }
            if ((zzboc2 = map2.get(changeListener)) == null) {
                zzboc2 = new zzboc(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzboc2);
            } else if (zzboc2.zzaO(1)) {
                return new zzbme(googleApiClient, Status.zzaBm);
            }
            zzboc2.zzaN(1);
            zzboc zzboc3 = zzboc2;
            zzbkr zzbkr2 = new zzbkr(1, driveId);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmh zzbmh2 = this;
            return googleApiClient2.zze((zzbay)new zzbmi(zzbmh2, googleApiClient2, zzbkr2, zzboc3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        zzbo.zzaf((boolean)zzj.zza(1, driveId));
        zzbo.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzbo.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzboc>> map = this.zzaNW;
        synchronized (map) {
            Map<ChangeListener, zzboc> map2 = this.zzaNW.get((Object)driveId);
            if (map2 == null) {
                return new zzbme(googleApiClient, Status.zzaBm);
            }
            zzboc zzboc2 = map2.remove(changeListener);
            if (zzboc2 == null) {
                return new zzbme(googleApiClient, Status.zzaBm);
            }
            if (map2.isEmpty()) {
                this.zzaNW.remove((Object)driveId);
            }
            zzboc zzboc3 = zzboc2;
            zzbqk zzbqk2 = new zzbqk(driveId, 1);
            GoogleApiClient googleApiClient2 = googleApiClient;
            zzbmh zzbmh2 = this;
            return googleApiClient2.zze((zzbay)new zzbmj(zzbmh2, googleApiClient2, zzbqk2, zzboc3));
        }
    }

    final PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        zzbkr zzbkr2 = new zzbkr(1, driveId);
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzbmh zzbmh2 = this;
        zzbo.zzaf((boolean)zzj.zza(zzbkr2.zzaJo, zzbkr2.zzaLV));
        zzbo.zza((boolean)zzbmh2.isConnected(), (Object)"Client must be connected");
        if (!zzbmh2.zzaNR) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient2.zze((zzbay)new zzbmk(zzbmh2, googleApiClient2, zzbkr2));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.drive.internal.IDriveService");
        if (iInterface instanceof zzbom) {
            return (zzbom)iInterface;
        }
        return new zzbon(iBinder2);
    }
}

